/**
 * Paypercut BNPL Admin JavaScript
 */

jQuery(document).ready(function($) {
    'use strict';

    // Test connection button
    $('#test-connection').on('click', function(e) {
        e.preventDefault();
        
        var button = $(this);
        var originalText = button.text();
        var apiKey = $('#paypercut_api_key').val();
        var apiSecret = $('#paypercut_api_secret').val();
        var testmode = $('#paypercut_testmode').is(':checked');
        
        if (!apiKey || !apiSecret) {
            showStatus('error', 'Please enter both API Key and API Secret.');
            return;
        }
        
        button.prop('disabled', true).html('<span class="paypercut-loading"></span>Testing...');
        
        $.ajax({
            url: paypercut_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'paypercut_test_connection',
                nonce: paypercut_ajax.nonce,
                api_key: apiKey,
                api_secret: apiSecret,
                testmode: testmode
            },
            success: function(response) {
                if (response.success) {
                    showStatus('success', response.data);
                } else {
                    showStatus('error', response.data);
                }
            },
            error: function() {
                showStatus('error', 'Connection test failed. Please try again.');
            },
            complete: function() {
                button.prop('disabled', false).text(originalText);
            }
        });
    });

    // Validate credentials button
    $('#validate-credentials').on('click', function(e) {
        e.preventDefault();
        
        var button = $(this);
        var originalText = button.text();
        var apiKey = $('#paypercut_api_key').val();
        var apiSecret = $('#paypercut_api_secret').val();
        var testmode = $('#paypercut_testmode').is(':checked');
        
        if (!apiKey || !apiSecret) {
            showStatus('error', 'Please enter both API Key and API Secret.');
            return;
        }
        
        button.prop('disabled', true).html('<span class="paypercut-loading"></span>Validating...');
        
        $.ajax({
            url: paypercut_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'paypercut_validate_api',
                nonce: paypercut_ajax.nonce,
                api_key: apiKey,
                api_secret: apiSecret,
                testmode: testmode
            },
            success: function(response) {
                if (response.success) {
                    showStatus('success', response.data);
                } else {
                    showStatus('error', response.data);
                }
            },
            error: function() {
                showStatus('error', 'Validation failed. Please try again.');
            },
            complete: function() {
                button.prop('disabled', false).text(originalText);
            }
        });
    });

    // Show status message
    function showStatus(type, message) {
        var statusDiv = $('#connection-status');
        var statusClass = 'paypercut-status ' + type;
        
        statusDiv.html('<div class="' + statusClass + '">' + message + '</div>');
        
        // Auto-hide success messages after 5 seconds
        if (type === 'success') {
            setTimeout(function() {
                statusDiv.fadeOut();
            }, 5000);
        }
    }

    // Form validation
    $('form').on('submit', function(e) {
        var apiKey = $('#paypercut_api_key').val();
        var apiSecret = $('#paypercut_api_secret').val();
        
        if (!apiKey || !apiSecret) {
            e.preventDefault();
            showStatus('error', 'Please enter both API Key and API Secret before saving.');
            return false;
        }
    });

    // Auto-save settings on change
    $('#paypercut_testmode').on('change', function() {
        var testmode = $(this).is(':checked');
        var statusText = testmode ? 'Test Mode Enabled' : 'Live Mode Enabled';
        showStatus('warning', statusText);
    });

    // Copy to clipboard functionality
    $('.copy-to-clipboard').on('click', function(e) {
        e.preventDefault();
        var text = $(this).data('copy');
        
        if (navigator.clipboard) {
            navigator.clipboard.writeText(text).then(function() {
                showStatus('success', 'Copied to clipboard!');
            });
        } else {
            // Fallback for older browsers
            var textArea = document.createElement('textarea');
            textArea.value = text;
            document.body.appendChild(textArea);
            textArea.select();
            document.execCommand('copy');
            document.body.removeChild(textArea);
            showStatus('success', 'Copied to clipboard!');
        }
    });

    // Toggle password visibility
    $('.toggle-password').on('click', function(e) {
        e.preventDefault();
        var input = $(this).siblings('input[type="password"]');
        var icon = $(this).find('i');
        
        if (input.attr('type') === 'password') {
            input.attr('type', 'text');
            icon.removeClass('dashicons-hidden').addClass('dashicons-visibility');
        } else {
            input.attr('type', 'password');
            icon.removeClass('dashicons-visibility').addClass('dashicons-hidden');
        }
    });

    // Real-time validation
    $('#paypercut_api_key, #paypercut_api_secret').on('input', function() {
        var apiKey = $('#paypercut_api_key').val();
        var apiSecret = $('#paypercut_api_secret').val();
        
        if (apiKey && apiSecret) {
            $(this).removeClass('error').addClass('valid');
        } else {
            $(this).removeClass('valid').addClass('error');
        }
    });

    // Initialize tooltips
    $('[data-tooltip]').each(function() {
        var tooltip = $(this).data('tooltip');
        $(this).attr('title', tooltip);
    });

    // Smooth scrolling for anchor links
    $('a[href^="#"]').on('click', function(e) {
        e.preventDefault();
        var target = $(this.getAttribute('href'));
        if (target.length) {
            $('html, body').animate({
                scrollTop: target.offset().top - 100
            }, 500);
        }
    });

    // Auto-refresh status every 30 seconds
    setInterval(function() {
        if ($('#connection-status .paypercut-status').length === 0) {
            // Only refresh if no status message is currently displayed
            return;
        }
        
        var apiKey = $('#paypercut_api_key').val();
        var apiSecret = $('#paypercut_api_secret').val();
        var testmode = $('#paypercut_testmode').is(':checked');
        
        if (apiKey && apiSecret) {
            $.ajax({
                url: paypercut_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'paypercut_test_connection',
                    nonce: paypercut_ajax.nonce,
                    api_key: apiKey,
                    api_secret: apiSecret,
                    testmode: testmode
                },
                success: function(response) {
                    if (response.success) {
                        $('#connection-status').html('<div class="paypercut-status success">API Connection: Active</div>');
                    } else {
                        $('#connection-status').html('<div class="paypercut-status error">API Connection: Failed</div>');
                    }
                }
            });
        }
    }, 30000);
});

