<?php

/**
 * Plugin Name: Payment Gateway for MyAmeriaPay
 * Description: Woocommerce payment gateway for MyAmeriaPay.
 * Version: 1.5.1
 * Author: Ameriabank
 * Author URI: https://ameriabank.am/
 * License: GPLv2 or later
 * Text Domain: payment-gateway-for-myameriapay
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * WC requires at least: 6.0
 * WC tested up to: 8.0
 * Tested up to: 6.8  
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Hook into WooCommerce to register the payment gateway
add_filter('woocommerce_payment_gateways', 'paymgafo_myameria_gateway_class');
function paymgafo_myameria_gateway_class($gateways)
{
    if (!class_exists('WooCommerce')) {
        return;
    }
    $gateways[] = 'PAYMGAFOAMERIA_Gateway';
    return $gateways;
}
function paymgafo_myameria_enqueue_styles()
{
    if (function_exists('is_checkout') && is_checkout()) {
        $css_version = filemtime(plugin_dir_path(__FILE__) . 'assets/css/paymgafo_myameria.css');
        wp_enqueue_style(
            'paymgafo-myameria-css',
            plugin_dir_url(__FILE__) . 'assets/css/paymgafo_myameria.css',
            array(),
            $css_version,
            'all'
        );
    }
}

add_action('wp_enqueue_scripts', 'paymgafo_myameria_enqueue_styles');
// Hook into the admin_enqueue_scripts action
add_action('admin_enqueue_scripts', 'paymgafo_myameria_admin_assets');

function paymgafo_myameria_admin_assets($hook)
{

    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- External payment gateway can't pass nonce
    if (
        $hook === 'woocommerce_page_wc-settings' &&
        isset($_GET['section']) &&    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $_GET['section'] === 'paymgafo_myameria_gateway'    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    ) {
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- External payment gateway can't pass nonce

        wp_enqueue_style('dashicons'); // Optional, if your admin UI needs it
        $admin_css_version = filemtime(plugin_dir_path(__FILE__) . 'assets/css/paymgafo_myameria_admin.css');
        wp_enqueue_style(
            'paymgafo-myameria-admin-css',
            plugin_dir_url(__FILE__) . 'assets/css/paymgafo_myameria_admin.css',
            array(),
            $admin_css_version,
            'all'
        );
        $script_version = filemtime(plugin_dir_path(__FILE__) . 'assets/js/admin.js');
        wp_enqueue_script(
            'paymgafo-myameria-admin-js',
            plugin_dir_url(__FILE__) . 'assets/js/admin.js',
            array('jquery'),
            $script_version,
            true
        );
    }
}
require_once plugin_dir_path(__FILE__) . 'includes/class-paymgafo-myameria-gateway.php';
require_once plugin_dir_path(__FILE__) . 'includes/functions.php';

add_action('plugins_loaded', 'paymgafo_myameria_init_gateway_class');
add_action('init', 'paymgafo_myameria_handle_payment_redirect');

add_action('woocommerce_blocks_loaded', function () {
    if (class_exists('Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
        require_once plugin_dir_path(__FILE__) . 'includes/class-paymgafo-myameria-gateway-blocks.php';
        add_action(
            'woocommerce_blocks_payment_method_type_registration',
            function (Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
                $payment_method_registry->register(new PAYMGAFOAMERIA_Gateway_Blocks());
            }
        );
    }
});
// After your plugin header comments
add_action('before_woocommerce_init', function () {
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    } else {
        add_action('admin_notices', 'paymgafo_myameria_hpos_incompatibility_notice');
    }
});


function paymgafo_myameria_hpos_incompatibility_notice()
{
?>
    <div class="notice notice-error">
        <p>
            <strong><?php esc_html_e('MyAmeria Pay Gateway Compatibility Issue', 'payment-gateway-for-myameriapay'); ?></strong>
        </p>
        <p>
            <?php esc_html_e('The MyAmeria Pay plugin is not currently compatible with the WooCommerce High-Performance Order Storage (HPOS) feature.', 'payment-gateway-for-myameriapay'); ?>
            <?php esc_html_e('Please disable HPOS to use this payment gateway.', 'payment-gateway-for-myameriapay'); ?>
        </p>
        <p>
            <a href="<?php echo esc_url(admin_url('admin.php?page=wc-settings&tab=advanced&section=features')); ?>" class="button-primary">
                <?php esc_html_e('Manage WooCommerce Features', 'payment-gateway-for-myameriapay'); ?>
            </a>
        </p>
    </div>
<?php
}
/**
 * Add settings link to plugin actions
 * 
 * @param array $actions Plugin action links
 * @return array Modified action links
 */
function paymgafo_myameria_add_settings_link($actions)
{
    $settings_link = sprintf(
        '<a href="%s">%s</a>',
        admin_url('admin.php?page=wc-settings&tab=checkout&section=paymgafo_myameria_gateway'),
        __('Settings', 'payment-gateway-for-myameriapay')
    );

    // Add the link at the beginning of the array
    array_unshift($actions, $settings_link);

    return $actions;
}

// Add filter for plugin action links
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'paymgafo_myameria_add_settings_link');
