<?php
if (!defined('ABSPATH')) {
    exit;
}

function paymgafo_myameria_handle_payment_redirect()
{
    if (!isset($_GET['transactionId'], $_GET['paymentId'], $_GET['status'])) {       // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        return;
    }
        $transactionId =  sanitize_text_field(wp_unslash($_GET['transactionId']));    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $paymentId = sanitize_text_field(wp_unslash($_GET['paymentId']));    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $status = sanitize_text_field(wp_unslash($_GET['status']));    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $merchantId = get_option('woocommerce_paymgafo_myameria_gateway_settings')['merchantId'] ?? '';
        $errorMessage = isset($_GET['errorMessage']) ? sanitize_text_field(wp_unslash($_GET['errorMessage'])) : '';    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        // Get the WooCommerce order based on transaction ID
        $order = wc_get_order($transactionId);
        if (!$order) {
            return; // Order not found, exit
        }
        // Check if the payment status is success
        if ($status === 'success') {
			   // Fetch the authentication token from session
            $token = $order->get_meta('_myameria_auth_token');
            if (!$token) {
                return; // Token not found, exit
             }
            // Verify payment status via API call
            $payment_status_response = paymgafo_myameria_check_payment_status($token, $transactionId, $paymentId, $merchantId);
            if (isset($payment_status_response['error'])) {
                // Handle API error
                $order->update_status('failed', 'Payment status check failed: ' . $payment_status_response['error']);
                return;
            }
            if ($payment_status_response['isSuccessful']) {
                // Mark order as completed
                $order->payment_complete($transactionId); // Mark order as complete with payment ID
                $order->save();
                $order->add_order_note('Payment successful. Payment ID: ' . $transactionId);
                // Redirect to Thank You page
                wp_safe_redirect( $order->get_checkout_order_received_url() );
                exit;
            } else {
                // Handle payment failure
                 $order->update_status('failed', 'Payment failed: ' . $errorMessage);
                 $order->add_order_note('Payment failed. Error: ' . $errorMessage);
                return;
            }
        } else {
            // Handle case where status is not success
            $order->update_status('failed', 'Payment was not successful: ' . $errorMessage);
            return;
        }
    
}


function paymgafo_myameria_check_payment_status($token, $transactionId, $paymentId, $merchantId)
{
    $gateway = new PAYMGAFOAMERIA_Gateway();
    $urls    = $gateway->get_api_urls();
    $status_url = $urls['status'];

    $response = wp_remote_post($status_url, [
        'body' => json_encode([
            'transactionId' => $transactionId,
            'paymentId' => $paymentId,
            'merchantId' => $merchantId,
        ]),
        'headers' => [
            'Authorization' => 'Bearer ' . $token,
            'Content-Type' => 'application/json',
        ],
        'timeout' => 90,
    ]);

    if (is_wp_error($response)) {
        return ['error' => $response->get_error_message()];
    }

    $response_body = wp_remote_retrieve_body($response);
    return json_decode($response_body, true);
}
