<?php
if (!defined('ABSPATH')) {
    exit;
}

class PAYMGAFOAMERIA_Gateway_Blocks extends Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType
{
    protected $gateway;

    public function initialize()
    {
        $this->gateway = new PAYMGAFOAMERIA_Gateway();
    }

    public function is_active()
    {
        return $this->gateway->is_available();
    }

    public function get_payment_method_script_handles()
    {
        wp_register_script(
            'paymgafo-myameria-pay-blocks',
            plugin_dir_url(__FILE__) . '../assets/js/blocks.js',
            ['wc-blocks-registry'],
            '1.5.1',
            true
        );
        wp_localize_script('paymgafo-myameria-pay-blocks', 'paymgafo_myameria_settings', [
            'paymgafo_myameria_gateway_data' => [
                'icon' => $this->gateway->icon,
                'title' => $this->gateway->title
            ]
        ]);
        return ['paymgafo-myameria-pay-blocks'];
    }

    public function get_payment_method_data()
    {
        return [
            'title' => $this->gateway->title,
            'description' => $this->gateway->description,
            'icon' => $this->gateway->icon,
            'supports' => $this->gateway->supports,
        ];
    }
}
