const { registerPaymentMethod } = window.wc.wcBlocksRegistry;
const { createElement } = window.wp.element;

registerPaymentMethod({
  name: "paymgafo_myameria_gateway",
  label: wp.i18n.__("MyAmeria Pay", "payment-gateway-for-myameriapay"),
  content: createElement(
    "div",
    null,
    wp.i18n.__(
      "Pay securely via AmeriaBank.",
      "payment-gateway-for-myameriapay"
    )
  ),
  edit: null,
  canMakePayment: () => true,
  ariaLabel: "MyAmeriaPay",
  supports: {
    features: ["products", "refunds", "subscriptions"],
  },
  icon: createElement("img", {
    src: paymgafo_myameria_settings.paymgafo_myameria_gateway_data.icon,
    alt: "MyAmeriaPay",
    style: { height: "24px" },
  }),
});
