jQuery(document).ready(function ($) {
  function toggleFields() {
    const enabled = $("#woocommerce_paymgafo_myameria_gateway_enabled").is(
      ":checked"
    );

    $("#mainform input, #mainform textarea , #mainform select").each(
      function () {
        const id = $(this).attr("id");
        if (id && id !== "woocommerce_paymgafo_myameria_gateway_enabled") {
          if (!enabled) {
            $(this).attr("readonly", true).css({
              "background-color": "rgb(233 233 233)",
              opacity: "0.6",
              "pointer-events": "none", // Also blocks clicks for select dropdowns
            });
          } else {
            $(this).removeAttr("readonly").css({
              "background-color": "",
              opacity: "",
              "pointer-events": "",
            });
          }
        }
      }
    );
  }

  toggleFields();
  $("#woocommerce_paymgafo_myameria_gateway_enabled").on(
    "change",
    toggleFields
  );

  const secretField = $("#woocommerce_paymgafo_myameria_gateway_clientSecret");

  if (secretField.length) {
    // Wrap the input in a container
    secretField.wrap(
      '<div style="position:relative; display:inline-block; width:100%;"></div>'
    );

    // Add eye icon
    const initialIconClass =
      secretField.attr("type") === "password"
        ? "dashicons-visibility"
        : "dashicons-hidden";
    const eyeBtn = $(
      `<span class="dashicons ${initialIconClass}" style="position:absolute; right:8px; top:4px; cursor:pointer;"></span>`
    );

    secretField.after(eyeBtn);

    // Toggle visibility on click
    eyeBtn.on("click", function () {
      const type =
        secretField.attr("type") === "password" ? "text" : "password";
      secretField.attr("type", type);

      // Change icon (dashicons-hidden / dashicons-visibility)
      $(this).toggleClass("dashicons-visibility dashicons-hidden");
    });
  }
  function clearErrors() {
    $(".myameria-error").remove();
  }

  // Insert error after input
  function showError(input, message) {
    const errorEl = $(
      '<div class="myameria-error" style="color: red; margin-top: 5px; font-size: 13px;">' +
        message +
        "</div>"
    );
    $(input).closest("td").append(errorEl);
  }
  const $form = $("form");
  const $saveButton = $form.find('button[name="save"]');
  $("form").on("submit", function (e) {
    const enabled = $("#woocommerce_paymgafo_myameria_gateway_enabled").is(
      ":checked"
    );
    clearErrors(); // Clear old errors
    if (enabled) {
      let hasErrors = false;

      const requiredFields = [
        {
          id: "#woocommerce_paymgafo_myameria_gateway_clientId",
          name: "Client ID",
        },
        {
          id: "#woocommerce_paymgafo_myameria_gateway_clientSecret",
          name: "Client Secret",
        },
        {
          id: "#woocommerce_paymgafo_myameria_gateway_merchantName",
          name: "Merchant Name",
        },
        {
          id: "#woocommerce_paymgafo_myameria_gateway_merchantId",
          name: "Merchant ID",
        },
        {
          id: "#woocommerce_paymgafo_myameria_gateway_terminalId",
          name: "Terminal ID",
        },
        {
          id: "#woocommerce_paymgafo_myameria_gateway_callback_scheme",
          name: "Callback Scheme",
        },
      ];

      requiredFields.forEach((field) => {
        const input = $(field.id);
        if (!input.val().trim()) {
          showError(input, `${field.name} is required.`);
          hasErrors = true;
        }
      });

      if (hasErrors) {
        e.preventDefault(); // Prevent form submission
        $saveButton.removeClass("is-busy");
        const $firstError = $(".myameria-error").first();
        if ($firstError.length) {
          $("html, body").animate(
            {
              scrollTop: $firstError.offset().top - 100, // Adjust offset as needed
            },
            400
          );
        }
      }
    }
  });
});
