<?php
if (!current_user_can('manage_options')) {
    return;
}

// Check if the form is submitted
if (isset($_POST['pffw_payment_method_fees_submit'])) {
    // Get the submitted form values
    $submitted_percentage_fees = isset($_POST['percentage_fee']) ? $_POST['percentage_fee'] : array();
    $submitted_absolute_fees = isset($_POST['absolute_fee']) ? $_POST['absolute_fee'] : array();
    $submitted_labels = isset($_POST['label']) ? $_POST['label'] : array();

    // Prepare the updated settings array
    $updated_settings = array();

    // Loop through the submitted values and add them to the updated settings array
    foreach ($submitted_percentage_fees as $gateway_id => $percentage_fee) {
        $gateway_id = sanitize_key($gateway_id);
        $absolute_fee = isset($submitted_absolute_fees[$gateway_id]) ? floatval($submitted_absolute_fees[$gateway_id]) : 0;
        $label = isset($submitted_labels[$gateway_id]) ? sanitize_text_field($submitted_labels[$gateway_id]) : '';

        $updated_settings[$gateway_id] = array(
            'percentage_fee' => floatval($percentage_fee),
            'absolute_fee' => $absolute_fee,
            'label' => $label
        );
    }

    // Save the updated settings in the WordPress options table
    update_option('pffw_payment_method_fees_settings', $updated_settings);
}

// Retrieve the saved payment method fees settings
$settings = get_option('pffw_payment_method_fees_settings', array());
?>

<div class="wrap">
    <h1>Payment fees for WooCommerce - Payment methods</h1>

    <form method="post" action="<?php echo esc_url(admin_url('admin.php?page=pffw_setup_admin_payment_method_fees_view')); ?>">
        <table class="form-table">
            <tr>
                <th>Payment Method</th>
                <th>Percentage Fee (%)</th>
                <th>Absolute Fee</th>
                <th>Label</th>
            </tr>
            <?php
            // Get all active WooCommerce payment gateways
            $payment_gateways = WC()->payment_gateways->payment_gateways();

            // Loop through each payment gateway and display a row in the settings table
            foreach ($payment_gateways as $gateway_id => $gateway) {
                $percentage_fee = isset($settings[$gateway_id]['percentage_fee']) ? $settings[$gateway_id]['percentage_fee'] : '';
                $absolute_fee = isset($settings[$gateway_id]['absolute_fee']) ? $settings[$gateway_id]['absolute_fee'] : '';
                $label = isset($settings[$gateway_id]['label']) ? $settings[$gateway_id]['label'] : '';
                ?>
                <tr>
                    <td><?php echo $gateway->get_title(); ?></td>
                    <td><input type="number" step="0.01" name="percentage_fee[<?php echo esc_attr($gateway_id); ?>]" value="<?php echo esc_attr($percentage_fee); ?>"></td>
                    <td><input type="number" step="0.01" name="absolute_fee[<?php echo esc_attr($gateway_id); ?>]" value="<?php echo esc_attr($absolute_fee); ?>"></td>
                    <td><input type="text" name="label[<?php echo esc_attr($gateway_id); ?>]" value="<?php echo esc_attr($label); ?>"></td>
                </tr>
                <?php
            }
            ?>
        </table>
        <p class="submit">
            <input type="submit" class="button-primary" name="pffw_payment_method_fees_submit" value="Save Changes">
        </p>
    </form>
</div>
