<?php
if (!current_user_can('manage_options')) {
    return;
}

// Retrieve the product categories
$categories = get_terms(array(
    'taxonomy' => 'product_cat',
    'hide_empty' => false,
));

// Check if the form is submitted
if (isset($_POST['pffw_category_fees_submit'])) {
    // Get the submitted form values
    $percentage_fees = $_POST['percentage_fee'];
    $absolute_fees = $_POST['absolute_fee'];
    $labels = $_POST['label'];

    // Prepare the settings array
    $settings = array();

    // Loop through the submitted values and add them to the settings array
    foreach ($percentage_fees as $index => $percentage_fee) {
        $category_id = $categories[$index]->term_id;
        $settings[$category_id] = array(
            'percentage_fee' => $percentage_fee,
            'absolute_fee' => $absolute_fees[$index],
            'label' => $labels[$index]
        );
    }

    // Save the settings in the WordPress options table
    update_option('pffw_category_fees_settings', $settings);
} else {
    // Retrieve the saved settings from the database
    $settings = get_option('pffw_category_fees_settings');
}
?>

<div class="wrap">
    <h1>Payment fees for WooCommerce - Category fees</h1>

    <form method="post" action="">
        <table class="form-table">
            <tr>
                <th>Category</th>
                <th>Percentage Fee (%)</th>
                <th>Absolute Fee</th>
                <th>Label</th>
            </tr>
            <?php
            // Loop through each category and display a row in the settings table
            foreach ($categories as $category) {
                $category_id = $category->term_id;
                $percentage_fee = isset($settings[$category_id]['percentage_fee']) ? $settings[$category_id]['percentage_fee'] : '';
                $absolute_fee = isset($settings[$category_id]['absolute_fee']) ? $settings[$category_id]['absolute_fee'] : '';
                $label = isset($settings[$category_id]['label']) ? $settings[$category_id]['label'] : '';
                ?>
                <tr>
                    <td style="padding-left: 0px;">
                        <?php echo $category->name; ?>
                    </td>
                    <td style="padding-left: 0px;"><input type="number" step="0.01" name="percentage_fee[]" value="<?php echo $percentage_fee; ?>"></td>
                    <td style="padding-left: 0px;"><input type="number" step="0.01" name="absolute_fee[]" value="<?php echo $absolute_fee; ?>"></td>
                    <td style="padding-left: 0px;"><input type="text" name="label[]" value="<?php echo $label; ?>"></td>
                </tr>
                <?php
            }
            ?>
        </table>
        <p class="submit">
            <input type="submit" class="button-primary" name="pffw_category_fees_submit" value="Save Changes">
        </p>
    </form>
</div>
