<?php
/*
* Plugin Name: Payment fees for WooCommerce
* Description: Allows setting fees for categories in WooCommerce based on paymentmethod and general category
* Version: 1.1.0
* Author: Aryus Software Applications UG (haftungsbeschränkt)
* Author URI: https://aryussoftwareapplications.com
* License: GPLv2 or later
* Text Domain: payment-fees-for-woocommerce
*/


if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Payment_Fees_For_WooCommerce {
    public $pluginbasename;

    function __construct() {

        $this->pluginbasename = plugin_basename( __FILE__ );

    }

    public function pffw_setup_admin_menu() {
        add_menu_page(
            'Payment fees for WooCommerce',
            'WC Payment fees',
            'nonexistent_capability',
            'payment_fees_for_woocommerce',
            array($this, 'pffw_settings_general_page'),
            'dashicons-cart',
            56
        );
    
        add_submenu_page(
            'payment_fees_for_woocommerce',
            'Category Fees',
            'Category Fees',
            'manage_options',
            'pffw_setup_admin_category_fees_view',
            array($this, 'pffw_setup_admin_category_fees_view')
        );
    
        add_submenu_page(
            'payment_fees_for_woocommerce',
            'Payment Method Fees',
            'Payment Method Fees',
            'manage_options',
            'pffw_setup_admin_payment_method_fees_view',
            array($this, 'pffw_setup_admin_payment_method_fees_view')
        );
    }

    public function pffw_setup_admin_category_fees_view() {
		require_once( plugin_dir_path( __FILE__ ) . 'template/admin_category_fees_view.php');	
	}

    public function pffw_setup_admin_payment_method_fees_view() {
        require_once ( plugin_dir_path( __FILE__ ) . 'template/admin_payment_method_fees_view.php' );
    }

    public function pffw_settings_general_page() {
        require_once ( plugin_dir_path( __FILE__ ) . 'template/admin_general_settings_page.php' );
    }

    public function pffw_activate() {}

	public function pffw_uninstall() {
        delete_option('pffw_category_fees_settings');
        delete_option('pffw_payment_method_fees_settings');
	}

	public function pffw_deactivate() {
		flush_rewrite_rules();
	}

    public function wc_apply_category_fees($cart) {
        if (is_admin() && !defined('DOING_AJAX')) {
            return;
        }
    
        $settings = get_option('pffw_category_fees_settings', array());
    
        foreach ($cart->get_cart() as $cart_item_key => $cart_item) {
            $product_id = $cart_item['product_id'];
            $quantity = $cart_item['quantity'];
            $product = wc_get_product($product_id);
    
            $product_categories = $product->get_category_ids();
            foreach ($product_categories as $category_id) {
                if (isset($settings[$category_id])) {
                    $fee_settings = $settings[$category_id];
                    $percentage_fee = isset($fee_settings['percentage_fee']) ? $fee_settings['percentage_fee'] : 0;
                    $absolute_fee = isset($fee_settings['absolute_fee']) ? $fee_settings['absolute_fee'] : 0;
                    $label = isset($fee_settings['label']) ? $fee_settings['label'] : '';
    
                    $fee = 0;
                    if ($percentage_fee) {
                        $fee += ($product->get_price() * $quantity) * ($percentage_fee / 100);
                    }
                    if ($absolute_fee) {
                        $fee += $absolute_fee * $quantity;
                    }
    
                    if ($fee > 0) {
                        $cart->add_fee($label, $fee);
                    }
    
                    $product->set_price($product->get_price() + $fee);
                }
            }
        }
    }

    public function apply_payment_method_fee($cart) {
        if (is_admin() && !defined('DOING_AJAX')) {
            return;
        }
    
        $chosen_payment_method = WC()->session->get('chosen_payment_method');
    
        if (!$chosen_payment_method) {
            return;
        }
    
        $settings = get_option('pffw_payment_method_fees_settings', array());
    
        if (!isset($settings[$chosen_payment_method])) {
            return;
        }
    
        $fee_settings = $settings[$chosen_payment_method];
        $percentage_fee = isset($fee_settings['percentage_fee']) ? $fee_settings['percentage_fee'] : 0;
        $absolute_fee = isset($fee_settings['absolute_fee']) ? $fee_settings['absolute_fee'] : 0;
        $label = isset($fee_settings['label']) ? $fee_settings['label'] : '';
    
        $fee = 0;
        if ($percentage_fee) {
            $fee += ($cart->subtotal * $percentage_fee / 100);
        }
        if ($absolute_fee) {
            $fee += $absolute_fee;
        }
    
        if ($fee > 0) {
            $cart->add_fee($label, $fee);
        }
    }

    function checkout_refresh() {
		wc_enqueue_js( "jQuery( function( $ ){
			$( 'form.checkout' ).on( 'change', 'input[name^=\"payment_method\"]', function(){
				$( 'body' ).trigger( 'update_checkout' );
			});
		});");
	}

}

if(class_exists('Payment_Fees_For_WooCommerce')) {
    $payment_fees_for_woocommerce = new Payment_Fees_For_WooCommerce();

    add_action('admin_menu', array($payment_fees_for_woocommerce, 'pffw_setup_admin_menu'));
    add_action('woocommerce_cart_calculate_fees', array($payment_fees_for_woocommerce, 'wc_apply_category_fees'), 10, 1);
    add_action( 'woocommerce_cart_calculate_fees', array($payment_fees_for_woocommerce, 'apply_payment_method_fee'), 25 );
    add_action( 'woocommerce_checkout_init', array($payment_fees_for_woocommerce, 'checkout_refresh'), 10 );
}
