<?php

// Exit if accessed directly
defined('ABSPATH') || exit;

function pemanager_sanitize_settings($input)
{
    $output = array();

    $output['auto_complete'] = ! empty($input['auto_complete']) ? 1 : 0;

    if (! empty($input['webhook_url'])) {
        $output['webhook_url'] = esc_url_raw($input['webhook_url']);
    }

    if (! empty($input['customer_message'])) {
        $output['customer_message'] = sanitize_textarea_field($input['customer_message']);
    }

    if (! empty($input['admin_message'])) {
        $output['admin_message'] = sanitize_textarea_field($input['admin_message']);
    }

    return $output;
}

function pemanager_settings_fields()
{

    register_setting(
        'pemanager_settings_group',
        'pemanager_settings',
        array(
            'sanitize_callback' => 'pemanager_sanitize_settings',
        )
    );

    add_settings_section(
        'pemanager_settings_section',

        __('Payment Error Handling', 'payment-error-manager'),

        function () {
            printf(
                '<p>%s</p>',
                esc_html__(
                    'Configure how WooCommerce should handle payment errors',
                    'payment-error-manager'
                )
            );
        },

        'pemanager-settings'
    );

    // checkbox field for autocompleting orders
    add_settings_field(
        'auto_complete',

        __('Auto-complete Order on Error', 'payment-error-manager'),

        function () {
            $options = get_option('pemanager_settings');

            printf(
                '<label><input type="checkbox" name="pemanager_settings[auto_complete]" value="1" %s /> %s</label>',
                checked(1, ! empty($options['auto_complete']), false),
                esc_html__('Enable', 'payment-error-manager')
            );
        },

        'pemanager-settings',
        'pemanager_settings_section'
    );

    // customer email body
    add_settings_field(
        'webhook_url',
        __('Webhook URL', 'payment-error-manager'),

        function () {
            $options = get_option('pemanager_settings');
            $val = !empty($options['webhook_url']) ? esc_textarea($options['webhook_url']) : '';

            printf(
                '<input type="url" name="pemanager_settings[webhook_url]" value="%s" class="large-text" />',
                esc_attr($val)
            );
        },

        'pemanager-settings',
        'pemanager_settings_section'
    );

    // customer email body
    add_settings_field(
        'customer_message',
        __('Customer Error Email', 'payment-error-manager'),

        function () {

            $options = get_option('pemanager_settings');
            $val = !empty($options['customer_message']) ? esc_textarea($options['customer_message']) : '';

            printf('<textarea name="pemanager_settings[customer_message]" rows="5" cols="50" class="large-text">%s</textarea>', esc_attr($val));

            printf(
                '<p class="description">%s</p>',
                esc_html__(
                    'Leave blank to disable sending customer email.',
                    'payment-error-manager'
                )
            );
        },

        'pemanager-settings',
        'pemanager_settings_section'
    );

    // admin email body
    add_settings_field(
        'admin_message',
        __('Admin Error Email', 'payment-error-manager'),

        function () {

            $options = get_option('pemanager_settings');
            $val = !empty($options['admin_message']) ? esc_textarea($options['admin_message']) : '';

            printf('<textarea name="pemanager_settings[admin_message]" rows="5" cols="50" class="large-text">%s</textarea>', esc_attr($val));

            printf(
                '<p class="description">%s</p>',
                esc_html__(
                    'Leave blank to disable sending admin email.',
                    'payment-error-manager'
                )
            );
        },

        'pemanager-settings',
        'pemanager_settings_section'
    );
}

// register settings
add_action('admin_init', 'pemanager_settings_fields');

// render settings page
function pemanager_render_settings_page()
{
?>
    <div class="wrap">
        <h1><?php esc_html_e('Payment Error Manager Settings', 'payment-error-manager'); ?></h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('pemanager_settings_group');
            do_settings_sections('pemanager-settings');
            submit_button();
            ?>
        </form>
    </div>
<?php
}

// add submenu under WooCommerce
add_action('admin_menu', function () {
    add_submenu_page(
        'woocommerce',
        __('Payment Error Manager', 'payment-error-manager'),
        __('Payment Error Manager', 'payment-error-manager'),
        'manage_options',
        'pemanager-manager',
        'pemanager_render_settings_page'
    );
});
