<?php

/**
 * Plugin Name: Payment Error Manager
 * Description: Never miss a sale again. Customize what happens when a customer encounters an error during payment.
 * Author: Yetsa
 * Author URI: https://yetsa.ng
 * Version: 1.0.0
 * License: GPLv2 or later
 * Text Domain: payment-error-manager
 */

defined('ABSPATH') || die();
defined('PaymentErrorManager_DIR') || define('PaymentErrorManager_DIR', plugin_dir_path(__FILE__));

// load payment error manager settings
function pemanager_load_settings()
{
    include_once(PaymentErrorManager_DIR . 'settings.php');
}

// adds admin notice when woocommerce isn't activated
function pemanager_wc_disabled_error_notice()
{

    add_action('admin_notices', function () {
        printf(
            '<div class="notice notice-error"><p>%s</p></div>',
            esc_html__('Payment Error Manager requires WooCommerce to be installed and active.', 'payment-error-manager')
        );
    });
}

// checks if woocommerce is installed and active
function pemanager_wc_actived()
{
    if (!function_exists('WC')) {

        pemanager_wc_disabled_error_notice();

        return false;
    }

    return true;
}

// register error managers
function pemanager_load_error_managers()
{
    if (pemanager_wc_actived()) {

        include_once(PaymentErrorManager_DIR . 'paystack-error-manager.php');

        $paystack_error_manager = \Yetsa\PaymentErrorManager\Paystack_Error_Manager::get_instance();
        $paystack_error_manager->register_error_handler();
    }
}

function pemanager_init()
{
    pemanager_load_settings();
    pemanager_load_error_managers();
}

add_action('plugins_loaded', 'pemanager_init');
