<?php

namespace Yetsa\PaymentErrorManager;

// Exit if accessed directly
defined('ABSPATH') || exit;

class Error_Handler
{
    // marks order as completed
    public function auto_complete_order($order, $options)
    {
        if ($order && $options) {

            if (!empty($options['auto_complete'])) {
                $order->update_status('completed', __('Auto-completed due to payment error manager setting.', 'payment-error-manager'));
            }
        }
    }

    // uses WC engine to send email
    protected function send_mail($to, $subject, $html_body)
    {
        // sanitize message first
        $allowed_tags = [
            'a'      => ['href' => [], 'title' => [], 'target' => []],
            'br'     => [],
            'em'     => [],
            'strong' => [],
            'p'      => [],
            'ul'     => [],
            'ol'     => [],
            'li'     => [],
        ];

        $safe_html = wp_kses($html_body, $allowed_tags);
        $headers  = ["Content-Type: text/html; charset=UTF-8"];

        // use WooCommerce mailer
        $mailer   = WC()->mailer();
        $message  = $mailer->wrap_message($subject, $safe_html);
        $mailer->send($to, $subject, $message, $headers);
    }

    // sends customer email
    public function send_customer_email($order, $options)
    {
        if ($order && $options) {

            if (!empty($options['customer_message'])) {

                $to = '';

                if ($order->get_billing_email()) {
                    // use billing email if available
                    $to = $order->get_billing_email();
                } else {
                    // otherwise, check if order has a user account
                    if ($order->get_user_id()) {
                        $user = get_user_by('id', $order->get_user_id());

                        if ($user) {
                            $to = $user->user_email;
                        }
                    }
                }

                if ($to) {

                    $subject = sprintf(
                        '[%s] %s - %s #%s',
                        esc_html(get_bloginfo('name')),
                        esc_html__('Payment Failed', 'payment-error-manager'),
                        esc_html__('Order', 'payment-error-manager'),
                        $order->get_order_number()
                    );


                    $message = strtr($options['customer_message'], [
                        '{first_name}'   => $order->get_billing_first_name(),
                    ]);

                    $this->send_mail($to, $subject, $message);
                }
            }
        }
    }

    // sends admin email
    public function send_admin_email($order, $options)
    {
        if ($order && $options) {
            if (!empty($options['admin_message'])) {

                $admin_email = get_option('admin_email');
                $subject = sprintf(
                    '[%s] %s',
                    esc_html(get_bloginfo('name')),
                    esc_html__('Payment Failed', 'payment-error-manager'),
                );


                $message = $options['admin_message'];

                $this->send_mail($admin_email, $subject, $message);
            }
        }
    }
}
