<?php
/**
 * Plugin Name: Paygenius Hosted Payment Gateway
 * Plugin URI: https://developer.paygenius.co.za/
 * Description: Take payments on your store using Paygenius hosted interface.
 * Author: PayGenius
 * Author URI: https://info.paygenius.co.za/
 * Version: 1.1.00
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: paygenius-hosted-payment-gateway
 *
 * @package PayGenius
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
if ( ! defined( 'PAYGENIUS_PLUGIN_FILE' ) ) {
	define( 'PAYGENIUS_PLUGIN_FILE', __FILE__ );
}
if ( ! defined( 'PAYGENIUS_PLUGIN_DIR' ) ) {
	define( 'PAYGENIUS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'PAYGENIUS_PLUGIN_URL' ) ) {
	define( 'PAYGENIUS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}
if ( ! defined( 'PAYGENIUS_TEXT_DOMAIN' ) ) {
	define( 'PAYGENIUS_TEXT_DOMAIN', 'paygenius-hosted-payment-gateway' );
}

// Initialize the plugin.
add_action( 'plugins_loaded', 'paygenius_redirect_init' );

/**
 * Initialize PayGenius Redirect gateway.
 */
function paygenius_redirect_init() {
	require_once PAYGENIUS_PLUGIN_DIR . 'lib/class-webclient.php';
	require_once PAYGENIUS_PLUGIN_DIR . 'lib/class-wc-paygenius-redirect.php';

	add_filter( 'woocommerce_payment_gateways', 'paygenius_redirect_add_gateway' );

	if ( class_exists( '\Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
		add_action(
			'woocommerce_blocks_payment_method_type_registration',
			function ( $payment_method_registry ) {
				require_once PAYGENIUS_PLUGIN_DIR . 'lib/includes/blocks/class-wc-paygenius-redirect-blocks.php';
				$payment_method_registry->register( new WC_Paygenius_Redirect_Blocks() );
			}
		);
	}
}

/**
 * Add PayGenius Redirect to WooCommerce payment gateways.
 *
 * @param array $methods Payment methods.
 * @return array
 */
function paygenius_redirect_add_gateway( $methods ) {
	$methods[] = 'WC_Paygenius_Redirect';
	return $methods;
}
