<?php
/**
 * Form fields configuration
 *
 * @package PayGenius
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

return array(
	'enabled'             => array(
		'title'       => esc_html__( 'Enable/Disable', 'paygenius-hosted-payment-gateway' ),
		'label'       => esc_html__( 'Enable Paygenius', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'checkbox',
		'description' => '',
		'default'     => 'no',
	),
	'title'               => array(
		'title'       => esc_html__( 'Title', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'text',
		'description' => esc_html__( 'This controls the title which the user sees during checkout.', 'paygenius-hosted-payment-gateway' ),
		'default'     => esc_html__( 'PayGenius Secure payment processing via Credit Card or EFT for South Africa', 'paygenius-hosted-payment-gateway' ),
		'desc_tip'    => true,
	),
	'description'         => array(
		'title'       => esc_html__( 'Description', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'textarea',
		'description' => esc_html__( 'This controls the description which the user sees during checkout.', 'paygenius-hosted-payment-gateway' ),
		'default'     => esc_html__( 'Pay by credit/cheque card or instant EFT. No need to register.', 'paygenius-hosted-payment-gateway' ),
		'desc_tip'    => true,
	),
	'button-text'         => array(
		'title'       => esc_html__( 'Button Text', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'text',
		'description' => esc_html__( 'The text that will appear on the button clicking through to the PayGenus hosted payment pages', 'paygenius-hosted-payment-gateway' ),
		'default'     => esc_html__( 'Place Order', 'paygenius-hosted-payment-gateway' ),
		'desc_tip'    => true,
	),
	'production-title'    => array(
		'title'       => esc_html__( 'Production Options', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'title',
		'description' => empty( $production_pages ) ? esc_html__( 'Please enter valid API details and ensure you have available payment pages', 'paygenius-hosted-payment-gateway' ) : '',
	),
	'paymentpage'         => array(
		'title'       => esc_html__( 'Payment Page', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'select',
		'description' => esc_html__( 'The payment page to redirect the user to', 'paygenius-hosted-payment-gateway' ),
		'default'     => '',
		'options'     => $production_pages,
		'desc_tip'    => true,
	),
	'endpoint'            => array(
		'title'       => esc_html__( 'Endpoint URL', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'text',
		'description' => esc_html__( 'Production endpoint', 'paygenius-hosted-payment-gateway' ),
		'default'     => 'https://www.paygenius.co.za/pg/api/v2/',
		'desc_tip'    => true,
	),
	'token'               => array(
		'title'       => esc_html__( 'Token', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'text',
		'description' => esc_html__( 'Get your API keys from your paygenius account.', 'paygenius-hosted-payment-gateway' ),
		'default'     => '',
		'desc_tip'    => true,
	),
	'secret'              => array(
		'title'       => esc_html__( 'Secret', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'text',
		'description' => esc_html__( 'Get your API keys from your paygenius account.', 'paygenius-hosted-payment-gateway' ),
		'default'     => '',
		'desc_tip'    => true,
	),
	'testing-title'       => array(
		'title'       => esc_html__( 'Testing Options', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'title',
		'description' => empty( $testing_pages ) ? esc_html__( 'Please enter valid API details and ensure you have available payment pages', 'paygenius-hosted-payment-gateway' ) : '',
	),
	'testmode'            => array(
		'title'       => esc_html__( 'Test mode', 'paygenius-hosted-payment-gateway' ),
		'label'       => esc_html__( 'Enable Test Mode', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'checkbox',
		'description' => esc_html__( 'Place the payment gateway in test mode using test API keys.', 'paygenius-hosted-payment-gateway' ),
		'default'     => 'no',
		'desc_tip'    => true,
	),
	'testing-paymentpage' => array(
		'title'       => esc_html__( 'Payment Page', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'select',
		'description' => esc_html__( 'The payment page to redirect the user to', 'paygenius-hosted-payment-gateway' ),
		'default'     => '',
		'options'     => $testing_pages,
		'desc_tip'    => true,
	),
	'testing-endpoint'    => array(
		'title'       => esc_html__( 'Endpoint URL', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'text',
		'description' => esc_html__( 'Testing endpoint', 'paygenius-hosted-payment-gateway' ),
		'default'     => 'https://developer.paygenius.co.za/pg/api/v2/',
		'desc_tip'    => true,
	),
	'testing-token'       => array(
		'title'       => esc_html__( 'Token', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'text',
		'description' => esc_html__( 'Get your API keys from your paygenius account.', 'paygenius-hosted-payment-gateway' ),
		'default'     => '',
		'desc_tip'    => true,
	),
	'testing-secret'      => array(
		'title'       => esc_html__( 'Secret', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'text',
		'description' => esc_html__( 'Get your API keys from your paygenius account.', 'paygenius-hosted-payment-gateway' ),
		'default'     => '',
		'desc_tip'    => true,
	),
	'use_sequence_number' => array(
		'title'       => esc_html__( 'Sequential Order Numbers', 'paygenius-hosted-payment-gateway' ),
		'label'       => esc_html__( 'Enable Sequential Order Numbers', 'paygenius-hosted-payment-gateway' ),
		'type'        => 'checkbox',
		'description' => esc_html__( 'This allows the use of Woocommerce Sequential order numbers', 'paygenius-hosted-payment-gateway' ),
		'default'     => 'no',
		'desc_tip'    => true,
	),
);
