<?php

namespace Paychef\Models\Request;

/**
 * QrCodeScan request class
 *
 * @copyright   Lieferchef AG
 * @author      Paychef Development Team <info@paychef.com>
 * @package     \Paychef\Models\Request
 */
class QrCodeScan extends \Paychef\Models\Base
{
    /**
     * mandatory
     *
     * @access  protected
     * @var     string
     */
    protected $sessionId;

    /**
     * @access  public
     * @return  string
     */
    public function getSessionId(): string
    {
        return $this->sessionId;
    }

    /**
     * @access  public
     * @param string $sessionId
     * @return  void
     */
    public function setSessionId(string $sessionId): void
    {
        $this->sessionId = $sessionId;
    }

    /**
     * {@inheritdoc}
     */
    public function getResponseModel()
    {
        return new \Paychef\Models\Response\QrCodeScan();
    }
}
