<?php
/**
 * The AuthToken request model
 * @created   for Paychef API
 * @modified  2024 by Roberto Coria <support@paychef.com>
 * @since     v1.0
 */

namespace Paychef\Models\Request;

/**
 * Class AuthToken
 * @package Paychef\Models\Request
 */
class AuthToken extends \Paychef\Models\Base
{
    protected $userId = 0;

    /**
     * The user id of the user you want an auth token for
     *
     * @return int
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * Set the user id you would like to get an auth token for
     *
     * @param int $userId
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;
    }

    /**
     * {@inheritdoc}
     */
    public function getResponseModel()
    {
        return new \Paychef\Models\Response\AuthToken();
    }
}
