<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$rawurl = get_bloginfo('url');
$url = wp_parse_url($rawurl);
$domain = preg_replace('#^(?:https?://)?(?:www\d?\.)?([^./]+).*$#', '$1', $url['host']);


if (!function_exists('add_paychef_copyable_text_field')) {
    function add_paychef_copyable_text_field($value) {
        $option_value = $value['default'];
        $field_id = esc_attr($value['id']);
        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $field_id; ?>"><?php echo esc_html($value['title']); ?></label>
            </th>
            <td class="forminp forminp-text">
                <input type="text" id="<?php echo $field_id; ?>" value="<?php echo esc_attr($option_value); ?>" style="width: 400px;" readonly>
                <button type="button" class="button-secondary paychef-copy-button" data-target="<?php echo $field_id; ?>">
                    <?php _e('Copy', 'paychef-payments-for-woocommerce'); ?>
                </button>
                <p class="description"><?php echo $value['description']; ?></p>
            </td>
        </tr>
        <?php
    }
}

if (!function_exists('add_paychef_copy_script')) {
    function add_paychef_copy_script() {
        $script = "
            jQuery(document).ready(function($) {
                $('.paychef-copy-button').on('click', function() {
                    var targetId = $(this).data('target');
                    var $input = $('#' + targetId);
                    $input.select();
                    document.execCommand('copy');
                    $(this).text('" . esc_js(__('Copied!', 'paychef-payments-for-woocommerce')) . "');
                    setTimeout(function() {
                        $('.paychef-copy-button').text('" . esc_js(__('Copy', 'paychef-payments-for-woocommerce')) . "');
                    }, 2000);
                });
            });
        ";
        wp_add_inline_script('jquery', $script);
    }
}
add_action('woocommerce_admin_field_paychef_copyable_text', 'add_paychef_copyable_text_field');
add_action('admin_enqueue_scripts', 'add_paychef_copy_script');


// Haupteinstellungen definieren
return apply_filters('wc_paychef_gateway_settings', [
    [
        'title' => __('API Settings', 'paychef-payments-for-woocommerce'),
        'id' => PAYCHEF_CONFIGS_PREFIX . 'api_settings',
        'type' => 'title',
        'desc' => sprintf(__('Already have an account? <a target="_blank" href="https://signup.paychef.com/?instance=%s">Register here</a>', 'paychef-payments-for-woocommerce'), $domain),
    ],
    [
        'title' => __('Instance Name', 'paychef-payments-for-woocommerce'),
        'id' => PAYCHEF_CONFIGS_PREFIX . 'instance',
        'type' => 'text',
        'desc' => __('The instance name is your Paychef account name. You find it in the URL when logged in INSTANCENAME.paychef.com.', 'paychef-payments-for-woocommerce'),
        'custom_attributes' => ['required' => 'required'],
    ],
    [
        'title' => __('API Key', 'paychef-payments-for-woocommerce'),
        'id' => PAYCHEF_CONFIGS_PREFIX . 'api_key',
        'type' => 'text',
        'desc' => __('Paste the API key from the integrations page of your Paychef merchant backend here', 'paychef-payments-for-woocommerce'),
        'default' => get_option("woocommerce_paychef_sid"),
        'custom_attributes' => ['required' => 'required'],
    ],
	[
		'type'         => 'verify_button',
		'title'        => __('Validate API Credentials', 'paychef-payments-for-woocommerce'),
		'id'           => PAYCHEF_CONFIGS_PREFIX . 'api_validation',
		'button_label' => __('Validate', 'paychef-payments-for-woocommerce'),
	],
    [
        'title' => __('Webhook URL', 'paychef-payments-for-woocommerce'),
        'type' => 'paychef_copyable_text',
        'id' => 'paychef_webhook_url',
        'default' => sprintf('%s/?wc-api=wc_paychef_gateway', get_bloginfo('url')),
        'description' => __('Use this URL in the Webhook section of your Paychef account.', 'paychef-payments-for-woocommerce'),
    ],
    [
        'type' => 'sectionend',
        'id' => PAYCHEF_CONFIGS_PREFIX . 'api_settings',
    ],
    [
        'title' => __('Additional Settings', 'paychef-payments-for-woocommerce'),
        'id' => PAYCHEF_CONFIGS_PREFIX . 'additional_settings',
        'type' => 'title',
    ],
    [
        'title' => __('Look&Feel Profile ID', 'paychef-payments-for-woocommerce'),
        'id' => PAYCHEF_CONFIGS_PREFIX . 'look_and_feel_id',
        'type' => 'text',
        'description' => __('Enter a look and feel profile ID if you wish to use a specific design in the checkout', 'paychef-payments-for-woocommerce'),
    ],
    [
        'title' => __('Prefix ', 'paychef-payments-for-woocommerce'),
        'id' => PAYCHEF_CONFIGS_PREFIX . 'prefix',
        'type' => 'text',
        'custom_attributes' => [],
        'description' => __('The Prefix is only necessary for merchants outside the Paychef platform', 'paychef-payments-for-woocommerce'),
        'desc_tip' => true,
    ],
    [
        'type' => 'sectionend',
        'id' => PAYCHEF_CONFIGS_PREFIX . 'additional_settings',
    ],
]);
?>