<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$settings = [
    'enabled' => [
        'title' => __('Enable/Disable', 'paychef-payments-for-woocommerce'),
        'type' => 'checkbox',
        'label' => __('Enable Payment Method', 'paychef-payments-for-woocommerce'),
        'default' => 'no',
    ],
    'title' => [
        'title' => __('Title', 'paychef-payments-for-woocommerce'),
        'type' => 'text',
        'description' => __('The title of the payment method which shows in the checkout.', 'paychef-payments-for-woocommerce'),
        'default' => $this->method_title,
        'desc_tip' => true,
        'custom_attributes' => ['required' => 'required'],
    ],
    'description' => [
        'title' => __('Description', 'paychef-payments-for-woocommerce'),
        'type' => 'textarea',
        'css' => 'width:400px;',
        'description' => __('The description of the paymment method which is visible in the checkout once selected.', 'paychef-payments-for-woocommerce'),
        'desc_tip' => true,
    ],
];

if ($this->id === 'paychef') {
	$default_logos = get_option("woocommerce_paychef_logos");
    $settings['logos'] = [
        'title' => __('Select Logo', 'paychef-payments-for-woocommerce'),
        'type' => 'multiselect',
        'css' => 'height: 400px;width:400px;',
        'description' => __('This controls the payment method logos the customer sees during checkout.', 'paychef-payments-for-woocommerce'),
        'default' => $default_logos,
        'desc_tip' => true,
        'options' => [
            'masterpass' => 'Masterpass',
            'mastercard' => 'Mastercard',
            'visa' => 'Visa',
            'apple_pay' => 'Apple Pay',
            'google_pay' => 'Google Pay',
            'samsung_pay' => 'Samsung Pay',
            'jcb' => 'JCB',
            'american_express' => 'American Express',
            'wirpay' => 'WIRpay',
            'paypal' => 'PayPal',
            'post-finance-pay' => 'Post Finance Pay',
            'post-finance-card' => 'PostFinance Card',
            'post-finance-e-finance' => 'PostFinance E-Finance',
            'twint' => 'TWINT',
            'bitcoin' => 'Bitcoin',
            'maestro' => 'Maestro',
            'klarna' => 'Klarna',
            'klarna_paynow' => 'Klarna Pay now',
            'klarna_paylater' => 'Klarna Pay Later',
            'eps' => 'EPS',
            'reka' => 'Reka',
            'boncard' => 'Boncard',
            'x-money' => 'xMoney',
            'powerpay' => 'Powerpay',
            'cembrapay' => 'CembraPay',
            'diners_club' => 'Diners Club',
            'direct_debit' => 'Direct Debit',
            'discover' => 'Discover',
            'ideal' => 'iDEAL',
            'invoice' => 'Invoice',
            'paysafecard' => 'Paysafe Card',
            'barzahlen' => 'Barzahlen/Viacash',
            'bancontact' => 'Bancontact',
            'giropay' => 'GiroPay',
            'paysafecash' => 'Paysafes Cash',


        ]
    ];
}

return apply_filters('wc_offline_form_fields', $settings);
