registerpaychefPaymentMethod = (id, defaultLabel ) => {
    const paymentMethodSettings = window.wc.wcSettings.getSetting( `${id}_data`, {} );
    if (!paymentMethodSettings || !paymentMethodSettings.title) {
        return;
    }
    const paymentMethodLabelText = window.wp.htmlEntities.decodeEntities( paymentMethodSettings.title ) || window.wp.i18n.__( defaultLabel, 'paychef-payments-for-woocommerce' );

    const { useEffect, useState } = window.wp.element;
    const ContentComponent = ( props ) => {
        const { id, eventRegistration, emitResponse } = props;
        const { onPaymentProcessing } = eventRegistration;
        const [selectedToken, setSelectedToken] = useState('new');
        const [savePaymentMethod, setSavePaymentMethod] = useState(false);

        useEffect( () => {
            const unsubscribe = onPaymentProcessing( async () => {
                const checkbox = document.getElementById('paychef-allow-recurring-' + id);
                const paychef_allow_recurring_block = checkbox && checkbox.checked ? 'paychef-allow-recurring-' + id : 'no';
                
                const paymentData = {
                    paychef_allow_recurring_block,
                };

                // Add tokenization data if supported
                if (paymentMethodSettings.supports && paymentMethodSettings.supports.includes('tokenization')) {
                    paymentData['wc-' + id + '-payment-token'] = selectedToken;
                    if (selectedToken === 'new' && savePaymentMethod) {
                        paymentData['wc-' + id + '-new-payment-method'] = true;
                    }
                }

                return {
                    type: emitResponse.responseTypes.SUCCESS,
                    meta: {
                        paymentMethodData: paymentData,
                    },
                };
            } );
            return () => {
                unsubscribe();
            };
        }, [
            emitResponse.responseTypes.ERROR,
            emitResponse.responseTypes.SUCCESS,
            onPaymentProcessing,
            selectedToken,
            savePaymentMethod,
        ] );

        // Create React elements for tokenization
        const elements = [];

        // Add description
        if (paymentMethodSettings.description) {
            elements.push(
                window.wp.element.createElement(
                    window.wp.element.RawHTML,
                    { key: 'description' },
                    paymentMethodSettings.description
                )
            );
        }

        // Add tokenization UI if supported
        if (paymentMethodSettings.supports && 
            paymentMethodSettings.supports.includes('tokenization') && 
            paymentMethodSettings.saved_tokens) {
            
            if (paymentMethodSettings.saved_tokens.length > 0) {
                elements.push(
                    window.wp.element.createElement(
                        'div',
                        { key: 'saved-methods', className: 'wc-saved-payment-methods' },
                        window.wp.element.createElement(
                            'p',
                            null,
                            window.wp.i18n.__('Please select a saved payment method:', 'paychef-payments-for-woocommerce')
                        ),
                        ...paymentMethodSettings.saved_tokens.map(token =>
                            window.wp.element.createElement(
                                'label',
                                { key: token.id },
                                window.wp.element.createElement('input', {
                                    type: 'radio',
                                    name: 'wc-' + id + '-payment-token',
                                    value: token.id,
                                    checked: selectedToken === token.id,
                                    onChange: () => setSelectedToken(token.id)
                                }),
                                ' ' + token.display_name
                            )
                        ),
                        window.wp.element.createElement(
                            'label',
                            { key: 'new-method' },
                            window.wp.element.createElement('input', {
                                type: 'radio',
                                name: 'wc-' + id + '-payment-token',
                                value: 'new',
                                checked: selectedToken === 'new',
                                onChange: () => setSelectedToken('new')
                            }),
                            ' ' + window.wp.i18n.__('Use a new payment method', 'paychef-payments-for-woocommerce')
                        )
                    )
                );
            }
            
            if (paymentMethodSettings.show_save_payment_method && selectedToken === 'new') {
                elements.push(
                    window.wp.element.createElement(
                        'label',
                        { 
                            key: 'save-method', 
                            style: { marginTop: '10px', display: 'block' } 
                        },
                        window.wp.element.createElement('input', {
                            type: 'checkbox',
                            name: 'wc-' + id + '-new-payment-method',
                            checked: savePaymentMethod,
                            onChange: (e) => setSavePaymentMethod(e.target.checked)
                        }),
                        ' ' + window.wp.i18n.__('Save payment information to my account for future purchases.', 'paychef-payments-for-woocommerce')
                    )
                );
            }
        }

        return window.wp.element.createElement(
            'div',
            null,
            ...elements
        );
    }

    const paymentMethod = {
        name: id,
        label: window.wp.element.createElement(
            'span',
            { style: { display: 'inline-flex', alignItems: 'center', gap: '8px' } },
            paymentMethodLabelText,
            window.wp.element.createElement(
                window.wp.element.RawHTML,
                null,
                paymentMethodSettings.icon || ''
            ),
        ),
        content: Object( window.wp.element.createElement )( ContentComponent, { id } ),
        edit: Object( window.wp.element.createElement )( ContentComponent, { id } ),
        canMakePayment: () => true,
        ariaLabel: paymentMethodLabelText,
        supports: {
            features: paymentMethodSettings.supports,
        },
    };

    window.wc.wcBlocksRegistry.registerPaymentMethod( paymentMethod );
}

registerpaychefPaymentMethod( 'paychef_american-express', 'Amex (paychef)' );
registerpaychefPaymentMethod( 'paychef_apple-pay', 'Apple Pay (paychef)' );
registerpaychefPaymentMethod( 'paychef_bank-transfer', 'Purchase on invoice' );
registerpaychefPaymentMethod( 'paychef_boncard', 'Boncard (paychef)' );
registerpaychefPaymentMethod( 'paychef_centi', 'Centi (paychef)' );
registerpaychefPaymentMethod( 'paychef_diners-club', 'Diners Club (paychef)' );
registerpaychefPaymentMethod( 'paychef_discover', 'Discover (paychef)' );
registerpaychefPaymentMethod( 'paychef_google-pay', 'Google Pay (paychef)' );
registerpaychefPaymentMethod( 'paychef_heidipay', 'Heidipay (paychef)' );
registerpaychefPaymentMethod( 'paychef_invoice', 'Bill (manual)' );
registerpaychefPaymentMethod( 'paychef_klarna', 'Klarna (paychef)' );
registerpaychefPaymentMethod( 'paychef_maestro', 'Maestro (paychef)' );
registerpaychefPaymentMethod( 'paychef_mastercard', 'Mastercard (paychef)' );
registerpaychefPaymentMethod( 'paychef_masterpass', 'Masterpass (paychef)' );
registerpaychefPaymentMethod( 'paychef_pay-by-bank', 'Pay by Bank (paychef)' );
registerpaychefPaymentMethod( 'paychef_paypal', 'Paypal (paychef)' );
registerpaychefPaymentMethod( 'paychef', 'paychef' );
registerpaychefPaymentMethod( 'paychef_post-finance-card', 'Post Finance Card (paychef)' );
registerpaychefPaymentMethod( 'paychef_post-finance-e-finance', 'Post Finance E-Finance (paychef)' );
registerpaychefPaymentMethod( 'paychef_post-finance-pay', 'Post Finance Pay (paychef)' );
registerpaychefPaymentMethod( 'paychef_reka', 'Reka (paychef)' );
registerpaychefPaymentMethod( 'paychef_samsung-pay', 'Samsung Pay (paychef)' );
registerpaychefPaymentMethod( 'paychef_twint', 'Twint (paychef)' );
registerpaychefPaymentMethod( 'paychef_visa', 'Visa (paychef)' );
registerpaychefPaymentMethod( 'paychef_wirpay', 'Wirpay (paychef)' );
registerpaychefPaymentMethod( 'paychef_x-money', 'xMoney (paychef)' );
registerpaychefPaymentMethod( 'paychef_powerpay', 'Powerpay (paychef)' );
registerpaychefPaymentMethod( 'paychef_cembrapay', 'CembraPay (paychef)' );
