<?php
/**
 * Plugin Name:       Parcelmind Shipping Suite
 * Description:       Seamlessly connect multiple sales channels for order management, generate shipping and invoice labels, track shipments, automate notifications, facilitate order lookup, and design a customized tracking page.
 * Version:           1.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * Author:            Parcel Mind
 * Author URI:        https://parcelmind.com
 * Text Domain:       parcelmind-shipping-suite
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

define('PARCELMIND_API_URL', 'https://parcelmind.com/api');
define('PARCELMIND_PATH', dirname(__FILE__));
define('PARCELMIND_PLUGIN_FILE', __FILE__);
define('PARCELMIND_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('PARCELMIND_PLUGIN_URL', plugin_dir_url(__FILE__));
define('PARCELMIND_ASSETS_URL', plugin_dir_url(__FILE__) . 'assets');

require_once PARCELMIND_PLUGIN_DIR . 'includes/admin/admin-page.php';

// Add links to plugin listing page
function parcelmind_plugin_links($links) {
    $settings_link = '<a href="admin.php?page=parcelmind-settings">' . __('Settings', 'parcelmind-shipping-suite') . '</a>';    
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'parcelmind_plugin_links');
