<?php
if (!defined('ABSPATH')) {
    exit;
}

function parcelmind_add_admin_menu() {
    add_menu_page(
        'Parcelmind Settings',
        'Parcelmind',
        'manage_options',
        'parcelmind-settings',
        'parcelmind_settings_page',
        PARCELMIND_ASSETS_URL . '/images/sidebar-parcelmind-logo.png'
    );
}
add_action('admin_menu', 'parcelmind_add_admin_menu');

function parcelmind_settings_page() {
    require_once PARCELMIND_PLUGIN_DIR . 'includes/admin/settings-page.php';
}

function parcelmind_enqueue_admin_scripts() {
    // Ensure jQuery is loaded before admin-script.js
    wp_enqueue_script(
        'parcelmind-admin-script',
        PARCELMIND_PLUGIN_URL . 'assets/js/admin-script.js',
        array('jquery'), // Added jQuery as a dependency
        '1.0.0',
        true
    );

    wp_enqueue_style(
        'parcelmind-admin-style',
        PARCELMIND_ASSETS_URL . '/css/bootstrap.v5.3.3.css',
        array(),
        '1.0.0',
        'all'
    );
    wp_localize_script('parcelmind-admin-script', 'parcelmind_ajax_object', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('parcelmind_save_settings_nonce'),
        'api_url'  => PARCELMIND_API_URL,
        'site_url' => get_site_url(),
        'home_url' => get_home_url(),
    ));
}
add_action('admin_enqueue_scripts', 'parcelmind_enqueue_admin_scripts');