jQuery(document).ready(function ($) {
    let companyId = localStorage.getItem('parcelmind_company_id');

    if (companyId) {
        $('#parcelmind').html('<button class="btn btn-secondary disabled" role="button" aria-disabled="true">Connected &#8646;</button><br><br><a href="https://parcelmind.com/login" target="_blank">Click here to Login</a>');
    } else {
        refreshDetails();
    }

    function refreshDetails() {
        // Prevent API call if localStorage is empty
        if (!parcelmind_ajax_object || !parcelmind_ajax_object.api_url) {
            console.error('parcelmind_ajax_object is not defined');
            return;
        }

        $.get(parcelmind_ajax_object.api_url + '/getcompany', { site_url: parcelmind_ajax_object.site_url })
            .done(function (response) {
                if (response && response.success) {
                    localStorage.setItem('parcelmind_company_id', response.result.company_id);
                    $('#parcelmind').html('<button class="btn btn-secondary disabled" role="button" aria-disabled="true">Connected &#8646;</button><br><br><a href="https://parcelmind.com/login" target="_blank">Click here to Login</a>');
                }
            })
            .fail(function (error) {
                console.error('API request failed:', error);
            });
    }
});
