<?php
/**
 * Settings page template for Parcel History Checker WordPress plugin.
 *
 * This template file displays the settings page for the Parcel History Checker plugin,
 * including a form for checking phone numbers and an area to display results.
 *
 * @package PHCWP
 * @textdomain parcel-history-checker
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.
?>
<div class="phcwp-container">
	<div id="phcwp-template">
		<h1><?php esc_html_e( 'Check Your Customer History', 'parcel-history-checker' ); ?></h1>
		<form id="phcwp-form">
			<div class="form-row">
				<input type="text" name="phone_number" placeholder="<?php esc_attr_e( 'Enter Phone Number', 'parcel-history-checker' ); ?>" required>
				<input type="submit" id="check_number" value="<?php esc_attr_e( 'Check', 'parcel-history-checker' ); ?>">
			</div>
		</form>
		<!-- Preloader -->
		<div id="phcwp-loader" style="display: none;">
			<img src="<?php echo esc_url( PHCWP_ASSETS_URL . 'img/loading.svg' ); ?>" alt="<?php esc_attr_e( 'Loading...', 'parcel-history-checker' ); ?>">
		</div>
		<!-- Results area -->
		<div id="phcwp-results">
		</div>
	</div>
</div>
