<?php
/**
 * Results template for Parcel History Checker WordPress plugin.
 *
 * This template file displays the results of a parcel history check,
 * including a table of courier details and summary statistics.
 *
 * @package PHCWP
 * @textdomain parcel-history-checker
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

// Calculate overall statistics
$overall_total = 0;
$overall_delivered = 0;
$overall_canceled = 0;

foreach ($data as $courier => $stats) {
    $overall_total += intval($stats['totalOrders']);
    $overall_delivered += intval($stats['ordersDelivered']);
    $overall_canceled += intval($stats['ordersCanceled']);
}

$success_rate = $overall_total > 0 ? round(($overall_delivered / $overall_total) * 100, 2) : 0;
?>

<div id="phcwp-results-template">
    <table>
        <thead>
            <tr>
                <th><?php esc_html_e('Courier', 'parcel-history-checker'); ?></th>
                <th><?php esc_html_e('Total', 'parcel-history-checker'); ?></th>
                <th><?php esc_html_e('Success', 'parcel-history-checker'); ?></th>
                <th><?php esc_html_e('Return', 'parcel-history-checker'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($data as $courier => $stats) : ?>
                <tr>
                    <td><?php echo esc_html($courier); ?></td>
                    <td><?php echo esc_html($stats['totalOrders']); ?></td>
                    <td><?php echo esc_html($stats['ordersDelivered']); ?></td>
                    <td><?php echo esc_html($stats['ordersCanceled']); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="summary">
        <span class="summary-item total">
            <?php
            /* translators: %s: Total number of orders */
            printf(esc_html__('Total Orders: %s', 'parcel-history-checker'), esc_html($overall_total));
            ?>
        </span>
        <span class="summary-item success">
            <?php
            /* translators: %s: Number of successfully delivered orders */
            printf(esc_html__('Success Orders: %s', 'parcel-history-checker'), esc_html($overall_delivered));
            ?>
        </span>
        <span class="summary-item failed">
            <?php
            /* translators: %s: Number of returned orders */
            printf(esc_html__('Return Orders: %s', 'parcel-history-checker'), esc_html($overall_canceled));
            ?>
        </span>
    </div>

    <div class="progress-bar">
        <div class="progress-bar-fill progress-bar-success" style="width: <?php echo esc_attr($success_rate); ?>%">
            <?php
            /* translators: %s: Success rate percentage */
            printf(esc_html__('%s%% Success', 'parcel-history-checker'), esc_html($success_rate));
            ?>
        </div>
        <div class="progress-bar-fill progress-bar-failed" style="width: <?php echo esc_attr(100 - $success_rate); ?>%">
            <?php
            /* translators: %s: Return rate percentage */
            printf(esc_html__('%s%% Return', 'parcel-history-checker'), esc_html(100 - $success_rate));
            ?>
        </div>
    </div>
</div>