<?php
/**
 * Plugin Name: Parcel History Checker
 * Description: This plugin calls an Api after an order is placed, stores the response as serialized data, and displays the data in the WordPress admin area.
 * Version:     1.0.0
 * Author:      Wp Pure
 * Author URI:  https://profiles.wordpress.org/wppure/
 * Text Domain: parcel-history-checker
 * License:     GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @package PHCWP
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants with PHCWP prefix.
define( 'PHCWP_VERSION', '1.0.0' );
define( 'PHCWP_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'PHCWP_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'PHCWP_ASSETS_URL', PHCWP_PLUGIN_URL . 'assets/' );

// Load Composer's autoloader if available.
if ( file_exists( __DIR__ . '/vendor/autoload.php' ) ) {
	require_once __DIR__ . '/vendor/autoload.php';
}

// Check if the Manager class exists before instantiating it.
if ( class_exists( 'PHCWP\Manager' ) ) {
	// Instantiate the manager class.
	$manager = new \PHCWP\Manager();
}
