<?php
/**
 * Api class for Parcel History Checker WordPress plugin.
 *
 * This file contains the Api class which handles Api requests
 * for the Parcel History Checker plugin.
 *
 * @package PHCWP
 */

namespace PHCWP;

defined( 'ABSPATH' ) || exit;

/**
 * Api class.
 *
 * Handles Api requests to external services.
 */
class Api {

	/**
	 * Base URL for Api requests.
	 *
	 * @var string
	 */
	private $base_url = 'https://api.wppure.com/check';

	/**
	 * Check phone number against the Api.
	 *
	 * @param string $phone_number The phone number to check.
	 * @return array|false The Api response data or false on error.
	 */
	public function check_phone_number( $phone_number ) {
		// Prepare the request URL.
		$url = $this->base_url . '/' . rawurlencode( $phone_number );

		// Call the Api using the GET method.
		$response = wp_remote_get( $url );

		if ( is_wp_error( $response ) ) {
			return false;
		}

		return $this->process_response( $response );
	}

	/**
	 * Process the Api response.
	 *
	 * @param array $response The response from wp_remote_get().
	 * @return array The processed response data.
	 */
	private function process_response( $response ) {
		$body = wp_remote_retrieve_body( $response );
		$data = json_decode( $body, true );

		// Return the processed data or an error message if the Api response is not as expected.
		if ( isset( $data['error'] ) ) {
			return array( 'error' => $data['error'] );
		}

		return $data;
	}
}
