jQuery(document).ready(function ($) {
    $('#phcwp-form').on('submit', function (e) {
        e.preventDefault();
        $('#phcwp-loader').show();
        $('#phcwp-results').hide();
        var phone_number = $('input[name="phone_number"]').val();
        $.ajax({
            url: ParcelHistoryChecker.ajax_url,
            type: 'POST',
            data: {
                action: 'check_phone_number',
                phone_number: phone_number,
                nonce: ParcelHistoryChecker.nonce
            },
            success: function (response) {
                $('#phcwp-loader').hide();
                if (response.success) {
                    loadResults();
                } else {
                    $('#phcwp-results').html('<h2>' + response.data + '</h2>').show();
                }
            },
            error: function () {
                $('#phcwp-loader').hide();
                $('#phcwp-results').html('<h2>Error retrieving data</h2>').show();
            }
        });
    });

    function loadResults() {
        $.ajax({
            url: ParcelHistoryChecker.ajax_url,
            type: 'POST',
            data: {
                action: 'load_parcel_checker_results',
                nonce: ParcelHistoryChecker.nonce
            },
            success: function (response) {
                if (response.success) {
                    $('#phcwp-results').html(response.data.html).show();
                } else {
                    $('#phcwp-results').html('<h2>' + response.data + '</h2>').show();
                }
            },
            error: function () {
                $('#phcwp-results').html('<h2>Error loading results</h2>').show();
            }
        });
    }
});