window.addEventListener("load", (event) => {
  // Check PageFluent status
  if (!WPJPFDATA?.options?.isActive) return;

  // Check keydown
  let keyFlag = false;
  document.addEventListener("keydown", function (event) {
    if (event.ctrlKey || event.shiftKey) keyFlag = true;
  });
  document.addEventListener("keyup", function (event) {
    if (event.ctrlKey || event.shiftKey) keyFlag = false;
  });

  // **************************** //
  // **   Get all able links   ** //
  // **************************** //

  const allLinks = document.querySelectorAll(
    'a:not([target="_blank"]):not([href^="#"]):not([href=""])[href]:not(.wpjpf-exluded):not(.wpjpf-exluded a):not(#wpadminbar a)'
  );

  // Get elements transitions
  const body = document.querySelector("body");
  const overlayElt = document.getElementById("wpjpf-overlay");
  const loaderElt = document.getElementById("wpjpf-loader");
  const fadeElt = overlayElt?.querySelector(".fade");
  const slideTopElt = overlayElt?.querySelector(".slide-top");
  const slideRightElt = overlayElt?.querySelector(".slide-right");
  const slideBottomElt = overlayElt?.querySelector(".slide-bottom");
  const slideLeftElt = overlayElt?.querySelector(".slide-left");

  // Get duration transitions (ms)
  const waitingDuration = 1500;
  const timeDuration = 700;
  const totalTime = parseInt(waitingDuration) + parseInt(timeDuration);
  const transitionEffect = "cubic-bezier(0.165, 0.84, 0.44, 1)";

  // ******************** //
  // **    Functions   ** //
  // ******************** //

  // Global functions

  const showOverlay = (time = 0) => {
    body.style.overflow = "hidden";
    setTimeout(() => {
      overlayElt.style.opacity = 1;
      overlayElt.style.visibility = "visible";
    }, time);
  };

  const hideOverlay = (time = 0) => {
    body.style.overflow = "hidden";
    setTimeout(() => {
      body.style.overflow = "initial";
      overlayElt.style.opacity = 0;
      overlayElt.style.visibility = "hidden";
    }, time);
  };

  const startNavigation = (totalTime, target) => {
    setTimeout(() => {
      window.location.href = target;
    }, totalTime);
  };

  //Loaders functions

  const showLoader = (time) => {
    setTimeout(() => {
      loaderElt.style.opacity = 1;
    }, time);
  };

  const hideLoader = (time) => {
    setTimeout(() => {
      loaderElt.style.opacity = 0;
    }, time);
  };

  // Effects functions

  const fadeIn = (link) => {
    link.addEventListener("click", (e) => {
      if (!keyFlag) {
        e.preventDefault();
        let target = e.currentTarget.href;
        showOverlay();
        fadeElt.classList.remove("fade--out");
        fadeElt.classList.add("fade--in");
        if (loaderElt) showLoader(timeDuration);
        startNavigation(totalTime, target);
      }
    });
  };

  const fadeOut = () => {
    fadeElt.classList.add("fade--out");
    if (loaderElt) hideLoader();
    hideOverlay(timeDuration);
  };

  const slideTopIn = (link) => {
    link.addEventListener("click", (e) => {
      if (!keyFlag) {
        e.preventDefault();
        let target = e.currentTarget.href;
        showOverlay();
        slideTopElt.style.animation = `slideTopIn ${timeDuration}ms ${transitionEffect} forwards`;
        if (loaderElt) showLoader(timeDuration);
        startNavigation(totalTime, target);
      }
    });
  };

  const slideTopOut = () => {
    if (loaderElt) hideLoader();
    slideTopElt.style.animation = `slideTopOut ${timeDuration}ms ${transitionEffect} forwards`;
    hideOverlay(timeDuration);
  };

  const slideRightIn = (link) => {
    link.addEventListener("click", (e) => {
      if (!keyFlag) {
        e.preventDefault();
        let target = e.currentTarget.href;
        showOverlay();
        slideRightElt.style.animation = `slideRightIn ${timeDuration}ms ${transitionEffect} forwards`;
        if (loaderElt) showLoader(timeDuration);
        startNavigation(totalTime, target);
      }
    });
  };

  const slideRightOut = () => {
    if (loaderElt) hideLoader();
    slideRightElt.style.animation = `slideRightOut ${timeDuration}ms ${transitionEffect} forwards`;
    hideOverlay(timeDuration);
  };

  const slideBottomIn = (link) => {
    link.addEventListener("click", (e) => {
      if (!keyFlag) {
        e.preventDefault();
        let target = e.currentTarget.href;
        showOverlay();
        slideBottomElt.style.animation = `slideBottomIn ${timeDuration}ms ${transitionEffect} forwards`;
        if (loaderElt) showLoader(timeDuration);
        startNavigation(totalTime, target);
      }
    });
  };

  const slideBottomOut = () => {
    if (loaderElt) hideLoader();
    slideBottomElt.style.animation = `slideBottomOut ${timeDuration}ms ${transitionEffect} forwards`;
    hideOverlay(timeDuration);
  };

  const slideLeftIn = (link) => {
    link.addEventListener("click", (e) => {
      if (!keyFlag) {
        e.preventDefault();
        let target = e.currentTarget.href;
        showOverlay();
        slideLeftElt.style.animation = `slideLeftIn ${timeDuration}ms ${transitionEffect} forwards`;
        if (loaderElt) showLoader(timeDuration);
        startNavigation(totalTime, target);
      }
    });
  };

  const slideLeftOut = () => {
    if (loaderElt) hideLoader();
    slideLeftElt.style.animation = `slideLeftOut ${timeDuration}ms ${transitionEffect} forwards`;
    hideOverlay(timeDuration);
  };

  // ******************** //
  // **     Calls      ** //
  // ******************** //

  for (const link of allLinks) {
    if (fadeElt) fadeIn(link);
    if (slideTopElt) slideTopIn(link);
    if (slideRightElt) slideRightIn(link);
    if (slideBottomElt) slideBottomIn(link);
    if (slideLeftElt) slideLeftIn(link);
  }

  if (fadeElt) fadeOut();
  if (slideTopElt) slideTopOut();
  if (slideRightElt) slideRightOut();
  if (slideBottomElt) slideBottomOut();
  if (slideLeftElt) slideLeftOut();

  const cleanup = () => {
    allLinks.forEach((link) => {
      link.replaceWith(link.cloneNode(true));
    });
  };
});

window.addEventListener("pageshow", (event) => {
  if (!event.persisted) return;
  if (!WPJPFDATA?.options?.isActive) return;
  document.body.style.overflow = "initial";
  const overlayElt = document.getElementById("wpjpf-overlay");
  const loaderElt = document.getElementById("wpjpf-loader");
  if (overlayElt) {
    overlayElt.style.opacity = 0;
    overlayElt.style.visibility = "hidden";
  }
  if (loaderElt) {
    loaderElt.style.opacity = 0;
  }
});
