<?php

namespace WPJPF;

use WPJPF\Admin;
use WPJPF\Create;

/**
 * Plugin Name:     PageFluent - Smooth Page Transitions & Loader
 * Plugin URI:      https://www.wp-jutsu.com/plugins/pagefluent
 * Description:     Add smooth transitions between your pages with logos, animations and styles without touching a line of code. 
 * Version:         1.0.2
 * Author:          WPJutsu
 * Author URI:      https://www.wp-jutsu.com
 * License:         GPL-3.0-or-later
 * License URI:     https://www.gnu.org/licenses/gpl-3.0.html
 * Text domain:     pagefluent
 */


// If this file is called directly, abort.
defined('ABSPATH') or die('Something went wrong.');
define('WPJPF_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WPJPF_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('WPJPF_SLUG', "pagefluent");
define('WPJPF_VERSION', "1.0.2");


class PageFluent
{
  /**
   * Constructor
   *
   * @since 1.0.0
   */
  public function __construct()
  {
    add_action('wp_enqueue_scripts', array($this, 'enqueue_public_scripts'));
    $this->load_dependencies();
  }

  /**
   * Include PageFluent admin class
   * 
   * @since 1.0.0
   */
  public function load_dependencies()
  {
    if (is_admin()) {
      include_once plugin_dir_path(__FILE__) . 'admin/class-wpjpf-admin.php';
    }
    if (!is_admin()) {
      include_once plugin_dir_path(__FILE__) . 'includes/class-wpjpf-dom.php';
    }
  }

  /**
   * PageFluent enqueue scripts.
   *
   * @since 1.0.0
   */
  public function enqueue_public_scripts()
  {
    if (!get_option('wpjpf_activate')) {
      return;
    }
    wp_enqueue_style('wpjpf_public_css', WPJPF_PLUGIN_URL . 'public/css/wpjpf-public.css', array(), WPJPF_VERSION);
    wp_enqueue_script('wpjpf_public_js', WPJPF_PLUGIN_URL . 'public/js/wpjpf-public.js', array(), WPJPF_VERSION, true);
    wp_localize_script('wpjpf_public_js', 'WPJPFDATA', array(
      'options' => array(
        'isActive'        => (bool) get_option('wpjpf_activate'),
        'transitionColor' => sanitize_hex_color(get_option('wpjpf_transition_color', '#000000')),
      )
    ));
  }
}

/**
 * Init plugin
 *
 * @since 1.0.0
 */
function wpjpf_run_plugin()
{
  new PageFluent();
  if (is_admin()) {
    new Admin();
  } else {
    new Create();
  }
}
add_action('plugins_loaded', 'WPJPF\\wpjpf_run_plugin');
