<?php

defined('ABSPATH') or die('Something went wrong.');

$wpjpf_colors = array(
  "black"   => "#000000",
  "white"   => "#ffffff",
  "red"     => "#ffadad",
  "orange"  => "#ffd6a5",
  "yellow"  => "#fdffb6",
  "green"   => "#caffbf",
  "blue"    => "#9bf6ff",
  "purple"  => "#bdb2ff",
  "pink"    => "#ffc6ff"
);

$wpjpf_transitions = array(
  "fade"              => array("legend" => "Fade"),
  "slide-top"         => array("legend" => "Slide to top"),
  "slide-right"       => array("legend" => "Slide to right"),
  "slide-bottom"      => array("legend" => "Slide to bottom"),
  "slide-left"        => array("legend" => "Slide to left"),
);

$wpjpf_is_transition_active = get_option('wpjpf_transition_activate');
$wpjpf_color_value     = get_option('wpjpf_transition_color', '#000000');
$wpjpf_transition_value     = get_option('wpjpf_transition');

?>

<div id="transitions-settings" class="wpjpf-settings__menu-content">

  <p class="wpjpf-settings__menu-content__title"><?php esc_html_e('Customize your transition :', 'pagefluent'); ?> </p>

  <div class="wpjpf-settings__menu-content__option">
    <label class="wpjpf-settings__menu-content__label" for="wpjpf_transition_activate"><?php esc_html_e('Enable transitions :', 'pagefluent'); ?></label>
    <div class="wpjpf-settings__menu-content__option__input">
      <input id="wpjpf_transition_activate" type="checkbox" name="wpjpf_transition_activate" value="1" <?php checked(1, $wpjpf_is_transition_active, true); ?>>
    </div>
  </div>

  <div class="wpjpf-settings__menu-content__option">
    <label for="wpjpf_transition_color" class="wpjpf-settings__menu-content__label">
      <?php esc_html_e('Select a color :', 'pagefluent'); ?>
    </label>
    <div class="wpjpf-settings__menu-content__colors-wrapper">
      <?php foreach ($wpjpf_colors as $wpjpf_label => $wpjpf_hex) : ?>
        <input type="radio" name="wpjpf_transition_color" id="<?php echo esc_attr($wpjpf_label); ?>" value="<?php echo esc_attr($wpjpf_hex); ?>" <?php checked($wpjpf_hex, $wpjpf_color_value, true); ?>>
        <label for="<?php echo esc_attr($wpjpf_label); ?>" style="--bullet-color:<?php echo esc_attr($wpjpf_hex); ?>;"></label>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="wpjpf-settings__menu-content__option">
    <label class="wpjpf-settings__menu-content__label">
      <?php esc_html_e('Select a transition :', 'pagefluent'); ?>
    </label>

    <div class="wpjpf-settings__menu-content__transitions-wrapper">
      <p class="wpjpf-settings__menu-content__tip"><?php esc_html_e('Note : View all the demonstrations in the official ', 'pagefluent'); ?><a href="https://www.wp-jutsu.com/documentation/pagefluent" target="_blank"><?php esc_html_e("documentation", 'pagefluent'); ?></a></p>
      <?php foreach ($wpjpf_transitions as $wpjpf_value => $wpjpf_data) : ?>
        <div>
          <input type="radio" name="wpjpf_transition" id="<?php echo esc_attr($wpjpf_value); ?>" value="<?php echo esc_attr($wpjpf_value); ?>" <?php checked($wpjpf_value, $wpjpf_transition_value, true); ?>>
          <label for="<?php echo esc_attr($wpjpf_value); ?>" data-name="<?php echo esc_attr($wpjpf_data['legend']); ?>">
            <p><?php echo esc_html($wpjpf_data['legend']); ?></p>
          </label>
        </div>
      <?php endforeach; ?>
      <a href="https://www.wp-jutsu.com/plugins/pagefluent/" target="_blank" class="wpjpf-settings__menu-content__more"><?php esc_html_e('Want more transitions ?', 'pagefluent'); ?></a>
    </div>
  </div>

</div>