<?php

defined('ABSPATH') or die('Something went wrong.');

$wpjpf_colors = array(
  "black"   => "#000000",
  "white"   => "#ffffff",
  "red"     => "#ffadad",
  "orange"  => "#ffd6a5",
  "yellow"  => "#fdffb6",
  "green"   => "#caffbf",
  "blue"    => "#9bf6ff",
  "purple"  => "#bdb2ff",
  "pink"    => "#ffc6ff"
);

$wpjpf_loaders = array(
  "spinner-basic"     => array("legend" => "Spinner"),
  "dots-basic"        => array("legend" => "Dots"),
  "bars-basic"        => array("legend" => "Bars"),
  "progressbar-basic" => array("legend" => "Progress"),
  "pulse-basic"       => array("legend" => "Pulse"),
);

$wpjpf_is_loader_active         = get_option('wpjpf_loader_activate');
$wpjpf_loader_color_value  = get_option('wpjpf_loader_color');
$wpjpf_loader_value             = get_option('wpjpf_loader');

?>

<div id="loaders-settings" class="wpjpf-settings__menu-content">

  <p class="wpjpf-settings__menu-content__title"><?php esc_html_e('Add a loader to your transition :', 'pagefluent'); ?> </p>

  <div class="wpjpf-settings__menu-content__option">
    <label class="wpjpf-settings__menu-content__label" for="wpjpf_loader_activate"><?php esc_html_e('Enable loader :', 'pagefluent'); ?></label>
    <div class="wpjpf-settings__menu-content__option__input">
      <input id="wpjpf_loader_activate" type="checkbox" name="wpjpf_loader_activate" value="1" <?php checked(1, $wpjpf_is_loader_active, true); ?>>
    </div>
  </div>

  <p class="wpjpf-settings__menu-content__title"><?php esc_html_e('Choose from these generic loaders :', 'pagefluent'); ?> </p>
  <div class="wpjpf-settings__menu-content__option">
    <label class="wpjpf-settings__menu-content__label">
      <?php esc_html_e('Select a color :', 'pagefluent'); ?>
    </label>
    <div class="wpjpf-settings__menu-content__colors-wrapper">
      <?php foreach ($wpjpf_colors as $wpjpf_label => $wpjpf_hex) : ?>
        <input type="radio" name="wpjpf_loader_color" id="loader-<?php echo esc_attr($wpjpf_label); ?>" value="<?php echo esc_attr($wpjpf_hex); ?>" <?php checked($wpjpf_hex, $wpjpf_loader_color_value, true); ?>>
        <label for="loader-<?php echo esc_attr($wpjpf_label); ?>" style="--bullet-color:<?php echo esc_attr($wpjpf_hex); ?>;"></label>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="wpjpf-settings__menu-content__option">
    <label class="wpjpf-settings__menu-content__label"><?php esc_html_e('Select a loader :', 'pagefluent'); ?></label>
    <div class="wpjpf-settings__menu-content__loaders-wrapper">
      <?php foreach ($wpjpf_loaders as $wpjpf_value => $wpjpf_data) : ?>
        <input type="radio" name="wpjpf_loader" id="<?php echo esc_attr($wpjpf_value); ?>" value="<?php echo esc_attr($wpjpf_value); ?>" <?php checked($wpjpf_value, $wpjpf_loader_value, true); ?>>
        <label for="<?php echo esc_attr($wpjpf_value); ?>" data-name="<?php echo esc_attr($wpjpf_data['legend']); ?>">
          <div class="<?php echo esc_attr($wpjpf_value); ?>" data-animation="<?php echo esc_attr($wpjpf_value); ?>">
            <?php if (esc_attr($wpjpf_value) === 'spinner-2') : ?>
              <?php for ($wpjpf_i = 1; $wpjpf_i <= 12; $wpjpf_i++) : ?>
                <span></span>
              <?php endfor; ?>
            <?php endif; ?>
            <?php if (esc_attr($wpjpf_value) === 'spinner-3') : ?>
              <?php for ($wpjpf_i = 1; $wpjpf_i <= 5; $wpjpf_i++) : ?>
                <span></span>
              <?php endfor; ?>
            <?php endif; ?>
          </div>
        </label>
      <?php endforeach; ?>
      <a href="https://www.wp-jutsu.com/plugins/pagefluent/" target="_blank" class="wpjpf-settings__menu-content__more"><?php esc_html_e('Want more loaders ?', 'pagefluent'); ?></a>
    </div>
  </div>
</div>