//************ ADMIN MENU ************//

const menuLinks = document.querySelectorAll(".wpjpf-settings__menu li");
const menuContents = document.querySelectorAll(".wpjpf-settings__menu-content");

for (const link of menuLinks) {
  link.addEventListener("click", (e) => {
    let id = link.dataset.menu;

    menuLinks.forEach((link) => {
      link === e.target
        ? link.classList.add("active")
        : link.classList.remove("active");
    });
    menuContents.forEach((content) => {
      content.id === id
        ? content.classList.add("active")
        : content.classList.remove("active");
    });
  });
}

//************ AJAX FORM ************//

const wpjpfSaveOptions = async (value) => {
  let formData = new FormData(value);

  const body = document.querySelector("body");
  const overlay = document.querySelector("#wpjpf-loading-mask");
  const toast = document.querySelector("#wpjpf-toast");
  const successMessage = document.querySelector("#wpjpf-toast-success");
  const errorMessage = document.querySelector("#wpjpf-toast-error");

  formData.append("_ajax_nonce", WPJPFADMINDATA.nonce);
  formData.append("action", "wpjpf_save_options_handler");

  body.style.cursor = "wait";
  overlay.style.display = "block";
  toast.classList.remove("active");

  const response = await fetch(WPJPFADMINDATA.optionsUrl, {
    method: "POST",
    body: formData,
  });

  if (response.ok) {
    const json = await response.json();
    if (json.success) {
      toast.classList.add("wpjpf-toast--success");
      successMessage.style.display = "block";
      successMessage.textContent = json.data.message;
      errorMessage.style.display = "none";
    } else {
      toast.classList.add("wpjpf-toast--error");
      successMessage.style.display = "none";
      errorMessage.textContent = json.data.message;
      errorMessage.style.display = "block";
    }
  } else {
    toast.classList.add("wpjpf-toast--error");
    successMessage.style.display = "none";
    errorMessage.style.display = "block";
  }

  body.style.cursor = "auto";
  overlay.style.display = "none";
  toast.classList.add("active");

  setTimeout(() => {
    toast.classList.remove("active");
  }, 5000);
};

const form = document.getElementById("wpjpf-settings-form");
if (form) {
  form.addEventListener("submit", (e) => {
    e.preventDefault();
    wpjpfSaveOptions(form);
  });
  document.addEventListener("keydown", function (e) {
    if (
      e.key === "s" &&
      (navigator.userAgentData.platform.match("macOS") ? e.metaKey : e.ctrlKey)
    ) {
      e.preventDefault();
      wpjpfSaveOptions(form);
    }
  });
}
