<?php

namespace WPJPF;

defined('ABSPATH') or die('Something went wrong.');

class Admin
{

  /**
   * Admin construct function
   * 
   * @since 1.0.0
   */
  public function __construct()
  {
    add_action('admin_menu', array($this, 'register_admin_menu'));
    add_action('admin_init', array($this, 'register_settings'));
    add_action("admin_enqueue_scripts", array($this, 'enqueue_admin_scripts'));
    add_action('wp_ajax_wpjpf_save_options_handler',  array($this, 'wpjpf_save_options_handler'));

    // Link to settings page from plugins screen
    add_filter('plugin_action_links_PageFluent/pagefluent.php', function ($links_array) {
      array_unshift($links_array, '<a href="https://www.wp-jutsu.com/plugins/pagefluent/" style="color:#f87c56; font-weight:bold;" target="_blank">GET PREMIUM</a>');
      array_unshift($links_array, '<a href="https://www.wp-jutsu.com/documentation/pagefluent" target="_blank">Docs</a>');
      array_unshift($links_array, '<a href="admin.php?page=wpjpf-options">Réglages</a>');
      return $links_array;
    });
  }


  /**
   * Enqueue admin scripts.
   *
   * @since 1.0.0
   */
  public function enqueue_admin_scripts($hook)
  {
    if ('toplevel_page_wpjpf-options' !== $hook) {
      return;
    }

    if (isset($_GET['page']) && $_GET['page'] !== 'wpjpf-options' && check_admin_referer()) return;
    wp_enqueue_style('wpjpf_admin_css', WPJPF_PLUGIN_URL . 'admin/css/wpjpf-admin.css', array(), WPJPF_VERSION);
    wp_enqueue_script('wpjpf_admin_js', WPJPF_PLUGIN_URL . 'admin/js/wpjpf-admin.js', array(), WPJPF_VERSION, true);
    wp_localize_script('wpjpf_admin_js', 'WPJPFADMINDATA', array(
      'optionsUrl' => admin_url('admin-ajax.php'),
      'nonce'      => wp_create_nonce('wpjpf_options_nonce'),
    ));
  }


  /**
   * Register admin menu.
   *
   * @since 1.0.0
   */
  public function register_admin_menu()
  {

    add_menu_page(
      'PageFluent Options',
      'PageFluent',
      'manage_options',
      'wpjpf-options',
      array(
        $this,
        'render_admin_page'
      ),
      'data:image/svg+xml;base64,' . base64_encode('<svg width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M16.7036 0.262279C16.5787 0.137104 16.4195 0.051821 16.2461 0.0172418C16.0726 -0.0173373 15.8929 0.000344551 15.7295 0.0680458C15.5662 0.135747 15.4266 0.250419 15.3285 0.397523C15.2304 0.544628 15.1783 0.717541 15.1786 0.894341V3.57257H4.46429C3.28028 3.57257 2.14478 4.04285 1.30756 4.87996C0.470343 5.71707 0 6.85243 0 8.03629L0 10.7145C0 11.1881 0.188137 11.6422 0.523024 11.977C0.85791 12.3119 1.31211 12.5 1.78571 12.5C2.25932 12.5 2.71352 12.3119 3.04841 11.977C3.38329 11.6422 3.57143 11.1881 3.57143 10.7145V8.03629C3.57143 7.79952 3.6655 7.57244 3.83294 7.40502C4.00038 7.2376 4.22749 7.14354 4.46429 7.14354H15.1786V9.82177C15.1783 9.99857 15.2304 10.1715 15.3285 10.3186C15.4266 10.4657 15.5662 10.5804 15.7295 10.6481C15.8929 10.7158 16.0726 10.7334 16.2461 10.6989C16.4195 10.6643 16.5787 10.579 16.7036 10.4538L21.1679 5.99012C21.251 5.90719 21.317 5.80867 21.362 5.70022C21.407 5.59176 21.4302 5.47548 21.4302 5.35806C21.4302 5.24063 21.407 5.12436 21.362 5.0159C21.317 4.90744 21.251 4.80892 21.1679 4.72599L16.7036 0.262279ZM9.26786 14.3533C9.43147 14.4205 9.57143 14.5348 9.66999 14.6817C9.76855 14.8285 9.82125 15.0014 9.82143 15.1782V17.8565H20.5357C20.7725 17.8565 20.9996 17.7624 21.1671 17.595C21.3345 17.4276 21.4286 17.2005 21.4286 16.9637V14.2855C21.4286 13.8119 21.6167 13.3578 21.9516 13.023C22.2865 12.6881 22.7407 12.5 23.2143 12.5C23.6879 12.5 24.1421 12.6881 24.477 13.023C24.8119 13.3578 25 13.8119 25 14.2855V16.9637C25 17.5499 24.8845 18.1303 24.6602 18.6719C24.4358 19.2135 24.107 19.7055 23.6924 20.12C23.2779 20.5345 22.7858 20.8633 22.2441 21.0876C21.7025 21.312 21.122 21.4274 20.5357 21.4274H9.82143V24.1057C9.82175 24.2825 9.76955 24.4554 9.67147 24.6025C9.57338 24.7496 9.43382 24.8643 9.27047 24.932C9.10713 24.9997 8.92735 25.0173 8.75395 24.9828C8.58054 24.9482 8.4213 24.8629 8.29643 24.7377L3.83214 20.274C3.74899 20.1911 3.68302 20.0926 3.63801 19.9841C3.593 19.8756 3.56983 19.7594 3.56983 19.6419C3.56983 19.5245 3.593 19.4082 3.63801 19.2998C3.68302 19.1913 3.74899 19.0928 3.83214 19.0099L8.29643 14.5462C8.42139 14.4214 8.58055 14.3365 8.75378 14.3021C8.92702 14.2678 9.10475 14.2856 9.26786 14.3533Z" fill="white"/></svg>
      ')
    );
  }

  /**
   * Register settings of admin form
   * 
   * @since 1.0.0
   */

  public function register_settings()
  {
    register_setting(
      'wpjpf-settings',
      'wpjpf_activate',
      array(
        'sanitize_callback' => 'sanitize_text_field',
      )
    );
    register_setting(
      'wpjpf-settings',
      'wpjpf_transition_color',
      array(
        'sanitize_callback' => 'sanitize_hex_color',
      )
    );
    register_setting(
      'wpjpf-settings',
      'wpjpf_transition_activate',
      array(
        'sanitize_callback' => 'sanitize_text_field',
      )
    );
    register_setting(
      'wpjpf-settings',
      'wpjpf_transition',
      array(
        'sanitize_callback' => 'sanitize_text_field',
      )
    );
    register_setting(
      'wpjpf-settings',
      'wpjpf_loader_activate',
      array(
        'sanitize_callback' => 'sanitize_text_field',
      )
    );
    register_setting(
      'wpjpf-settings',
      'wpjpf_loader',
      array(
        'sanitize_callback' => 'sanitize_text_field',
      )
    );
    register_setting(
      'wpjpf-settings',
      'wpjpf_loader_color',
      array(
        'sanitize_callback' => 'sanitize_hex_color',
      )
    );
  }

  /**
   * Display admin form
   * 
   * @since 1.0.0
   */

  public function render_admin_page()
  {
    $label = "FREE VERSION";
?>

    <div id="wpjpf-loading-mask"></div>

    <div class="wpjpf-topbar">
      <?php esc_html_e('Get premium version and unlock amazing features', 'pagefluent'); ?>
      <a href="https://www.wp-jutsu.com/plugins/pagefluent/" class="wpjpf-settings__submit-btn wpjpf-settings__submit-btn--secondary " target="_blank"><?php esc_html_e('Get premium version', 'pagefluent'); ?></a>
    </div>

    <div id="wpjpf-toast">
      <span id="wpjpf-toast-success"><?php esc_html_e('Settings saved', 'pagefluent'); ?></span>
      <span id="wpjpf-toast-error"><?php esc_html_e('Oups, something went wrong', 'pagefluent'); ?></span>
    </div>

    <div id="wpjpf-settings">
      <div class="wpjpf-settings-header">
        <h1 class="wpjpf-settings-header__title"><img src="<?php echo esc_url(WPJPF_PLUGIN_URL); ?>admin/assets/images/wpjpf-logo.svg" alt="WPJPF Logo"> <span><?php echo esc_html($label); ?></span></h1>
        <ul class="wpjpf-settings-header__links">
          <li>
            <img src="<?php echo esc_url(WPJPF_PLUGIN_URL); ?>admin/assets/images/doc.svg" alt="Premium licence">
            <a href="https://www.wp-jutsu.com/plugins/pagefluent/" target="_blank"><?php esc_html_e('Get your premium licence', 'pagefluent'); ?></a>
          </li>
          <li>
            <img src="<?php echo esc_url(WPJPF_PLUGIN_URL); ?>admin/assets/images/doc.svg" alt="Documentation">
            <a href="https://www.wp-jutsu.com/documentation/pagefluent" target="_blank"><?php esc_html_e('Documentation', 'pagefluent'); ?></a>
          </li>
          <li>
            <img src="<?php echo esc_url(WPJPF_PLUGIN_URL); ?>admin/assets/images/star.svg" alt="Rate this plugin">
            <a href="#" target="_blank"><?php esc_html_e('Rate this plugin ?', 'pagefluent'); ?></a>
          </li>
        </ul>
      </div>

      <form id="wpjpf-settings-form" class="wpjpf-settings-main" method="post" action="<?php echo esc_url(admin_url('options.php')); ?>">

        <?php settings_fields('wpjpf-settings'); ?>
        <?php do_settings_sections('wpjpf-settings'); ?>

        <ul class="wpjpf-settings__menu">
          <li data-menu="global-settings" class="active">
            <img src="<?php echo esc_url(WPJPF_PLUGIN_URL); ?>admin/assets/images/settings.svg" alt="Settings">
            <?php esc_html_e('Global settings', 'pagefluent'); ?>
          </li>
          <li data-menu="transitions-settings">
            <img src="<?php echo esc_url(WPJPF_PLUGIN_URL); ?>admin/assets/images/reload.svg" alt="Transitions">
            <?php esc_html_e('Transitions', 'pagefluent'); ?>
          </li>
          <li data-menu="loaders-settings">
            <img src="<?php echo esc_url(WPJPF_PLUGIN_URL); ?>admin/assets/images/loader.svg" alt="Loaders">
            <?php esc_html_e('Loaders', 'pagefluent'); ?>
          </li>

          <?php
          submit_button(__('Save settings', 'pagefluent'), 'wpjpf-settings__submit-btn', 'wpjpf_submit_ajax', false);
          if (wp_doing_ajax()) :
            wp_die();
          endif;
          ?>
          <p><?php esc_html_e('( or press CTRL + S )', 'pagefluent'); ?></p>

        </ul>
        <div class="wpjpf-settings__content">

          <?php include_once(dirname(__FILE__) . '/partials/wpjpf-global-settings.php'); ?>
          <?php include_once(dirname(__FILE__) . '/partials/wpjpf-transitions-settings.php'); ?>
          <?php include_once(dirname(__FILE__) . '/partials/wpjpf-loaders-settings.php'); ?>

        </div>
      </form>
      <div class="wpjpf-premium-features">
        <p class="wpjpf-premium-features__title"><?php esc_html_e('Unlock premium features', 'pagefluent'); ?></p>
        <div class="wpjpf-premium-features__content">
          <div class="wpjpf-premium-features__content__item">
            <img src="<?php echo esc_url(WPJPF_PLUGIN_URL); ?>admin/assets/images/reload.svg" alt="Transitions">
            <p><?php esc_html_e('Transitions', 'pagefluent'); ?></p>
            <ul>
              <li><?php esc_html_e('More than 15+ transitions', 'pagefluent'); ?></li>
              <li><?php esc_html_e('Customize the color of the transition, for perfect integration with your branding', 'pagefluent'); ?></li>
              <li><?php esc_html_e('Adjust the in/out duration of your transition, as well as the waiting time', 'pagefluent'); ?></li>
              <li><?php esc_html_e('Activate your transition effect on every page or only on the user\'s first visit.', 'pagefluent'); ?></li>
            </ul>
          </div>
          <div class="wpjpf-premium-features__content__item">
            <img src="<?php echo esc_url(WPJPF_PLUGIN_URL); ?>admin/assets/images/loader.svg" alt="Loaders">
            <p><?php esc_html_e('Loaders', 'pagefluent'); ?></p>
            <ul>
              <li><?php esc_html_e('More than 15+ loaders', 'pagefluent'); ?></li>
              <li><?php esc_html_e('Customize the color of the loader, for perfect integration with your branding', 'pagefluent'); ?></li>
              <li><?php esc_html_e('Add your logo or any custom image as a loader for perfect branding', 'pagefluent'); ?></li>
            </ul>
          </div>
        </div>
        <a href="https://www.wp-jutsu.com/plugins/pagefluent/" class="wpjpf-settings__submit-btn" target="_blank"><?php esc_html_e('Get premium version', 'pagefluent'); ?></a>
      </div>
    </div>

<?php
  }


  /**
   * AJAX Settings  Request hanlder
   * 
   * @since 1.0.0
   */
  public function wpjpf_save_options_handler()
  {

    check_ajax_referer('wpjpf_options_nonce', '_ajax_nonce', true);

    if (!current_user_can('manage_options')) {
      wp_send_json_error(array(
        'message' => __('You do not have permission to perform this action.', 'pagefluent')
      ), 403);
    }

    $post_data = filter_input_array(INPUT_POST, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    if (isset($_POST['wpjpf_transition_color'])) {
      $wpjpf_transition_color =  sanitize_hex_color(wp_unslash($_POST['wpjpf_transition_color']));
      update_option('wpjpf_transition_color', $wpjpf_transition_color);
    }
    if (isset($_POST['wpjpf_transition'])) {
      $wpjpf_transition = sanitize_text_field(wp_unslash($_POST['wpjpf_transition']));
      update_option('wpjpf_transition', $wpjpf_transition);
    }
    if (isset($_POST['wpjpf_loader'])) {
      $wpjpf_loader = sanitize_text_field(wp_unslash($_POST['wpjpf_loader']));
      update_option('wpjpf_loader', $wpjpf_loader);
    }
    if (isset($_POST['wpjpf_loader_color'])) {
      $wpjpf_loader_color = sanitize_hex_color(wp_unslash($_POST['wpjpf_loader_color']));
      update_option('wpjpf_loader_color', $wpjpf_loader_color);
    }

    $post_data['wpjpf_activate'] === "1" ?
      update_option('wpjpf_activate', true) : update_option('wpjpf_activate', false);

    $post_data['wpjpf_transition_activate'] === "1" ?
      update_option('wpjpf_transition_activate', true) : update_option('wpjpf_transition_activate', false);

    $post_data['wpjpf_loader_activate'] === "1" ?
      update_option('wpjpf_loader_activate', true) : update_option('wpjpf_loader_activate', false);

    wp_send_json_success(
      array(
        'message' => __('Options saved succesfully', 'pagefluent')
      )
    );
  }
}
