<?php

namespace Pacific\Core\Dto\Shop;

use Pacific\Core\Dto\Shop\Price;

class Product {

    /** @var string $sku */
    public $sku;

    /** @var Price */
    public $price;

    /** @var string $name */
    public $name;

    /** @var string $productId */
    public $productId;

    /** @var string $externalProductId */
    public $externalProductId;

    /** @var int $quantity */
    public $quantity;

	/** @var string $image */
	public $image;

	/** @var Attribute[]  */
	public $attributes = [];

	/** @var array */
	private $allAttributes = [];

	/** @return array */
	public function getAllAttributes(): array {
		return $this->allAttributes;
	}

	/** @param array $allAttributes */
	public function setAllAttributes(array $allAttributes): void {
		$this->allAttributes = $allAttributes;
	}

}
