<?php

namespace Pacific\Core\Api;

use Pacific\Core\Dto\Shop\ShopShippingMethod;

class ShopContext extends Context {

	/** @return ShopShippingMethod[] */
	public function getMerchantShippingMethods()
	{
		$response = $this->request->doRequest(
			'GET',
			"v1/e-commerce/merchants/{$this->_configuration->getMerchantId()}/shipping",
			$this->_gateway->merchantCredentials
		);

		return $this->serializer->deserialize($response->getContent(false), ShopShippingMethod::class.'[]', 'json');
	}

	// @todo: implement getMerchantPaymentMethods()
	/** @return ShopShippingMethod */
	public function getMerchantShippingMethod(string $addressId)
	{
		$response = $this->request->doRequest(
			'GET',
			"v1/e-commerce/merchants/{$this->_configuration->getMerchantId()}/shipping/{$addressId}",
			$this->_gateway->merchantCredentials
		);

		return $this->serializer->deserialize($response->getContent(false), ShopShippingMethod::class, 'json');
	}
}
