<?php

namespace Pacific\Core\Api;

use Pacific\Core\Dto\Regulation\PacificRegulation;
use Pacific\Core\Exception\HttpExceptionInterface;

class RegulationContext extends Context {

    /**
     * Get specified terms
     *
     * @param string $type PacificRegulation::TYPE_PRIVACY_POLICY | PacificRegulation::TYPE_TERMS_AND_CONDITIONS
     * @return PacificRegulation
     * @throws HttpExceptionInterface
     */
    public function getTerm(string $type)
    {
        $response = $this->request->doRequest(
            'GET',
            "/v1/terms/{$type}",
            $this->_gateway->merchantCredentials,
            []
        );

        return $this->serializer->deserialize(
            $response->getContent(false),
            PacificRegulation::class,
            'json'
        );
    }
}
