<?php

namespace Pacific\Core\Api;

use Pacific\Core\Dto\Payment\PayByPayu;
use Pacific\Core\Dto\Payment\PayByPayuOutput;
use Pacific\Core\Dto\Payment\PaymentMethodsOutput;
use Pacific\Core\Dto\Payment\StoreCardTokenPayuOutput;
use Pacific\Core\Exception\HttpExceptionInterface;
use Pacific\Core\Service\Credentials\ClientCredentials;

class PaymentContext extends Context {

    /**
     * Store card token
     *
     * @param ClientCredentials $clientCredentials
     * @param PayByPayu $payment
     * @return StoreCardTokenPayuOutput
     * @throws HttpExceptionInterface
     */
	public function storeCardToken(ClientCredentials $clientCredentials, PayByPayu $payment)
	{
        $userData = $this->_gateway->userContext()->getUserData($clientCredentials);
        $response = $this->request->doRequest(
            'POST',
            "/v1/e-commerce/cards/{$userData->uuid}/token",
            $clientCredentials,
            [
                'json' => $payment,
                'headers' => [
                    'x-user-origin' => 'PLUGIN' // header required by pacific
                ]
            ],
            false
        );

        return $this->serializer->deserialize(
            $response->getContent(false),
            StoreCardTokenPayuOutput::class,
            'json'
        );
	}

    /**
     * Delete card token
     *
     * @param ClientCredentials $clientCredentials
     * @throws HttpExceptionInterface
     */
    public function deleteCardToken(ClientCredentials $clientCredentials, $token)
    {
        $userData = $this->_gateway->userContext()->getUserData($clientCredentials);
        $this->request->doRequest(
            'DELETE',
            "/v1/e-commerce/cards/{$userData->uuid}/token/{$token}",
            $clientCredentials,
            [
                'headers' => [
                    'x-user-origin' => 'PLUGIN' // header required by pacific
                ]
            ]
        );
    }

    /**
     * Fetch payment methods
     *
     * @param ClientCredentials $clientCredentials
     * @return PaymentMethodsOutput
     * @throws HttpExceptionInterface
     */
    public function fetchPaymentMethods(ClientCredentials $clientCredentials)
    {
        $response = $this->request->doRequest(
            'GET',
            "/v1/e-commerce/payments/fetch-methods",
            $clientCredentials,
            [
                'headers' => [
                    'x-user-origin' => 'PLUGIN' // header required by pacific
                ]
            ]
        );

        return $this->serializer->deserialize(
            $response->getContent(false),
            PaymentMethodsOutput::class,
            'json'
        );
    }

    /**
     * Fetch payment methods
     *
     * @param ClientCredentials $clientCredentials
     * @param PayByPayu $payment
     * @param $checkoutId
     * @return PaymentMethodsOutput
     * @throws HttpExceptionInterface
     */
    public function payByPayu(ClientCredentials $clientCredentials, PayByPayu $payment, $checkoutId)
    {

        $userData = $this->_gateway->userContext()->getUserData($clientCredentials);
        $response = $this->request->doRequest(
            'POST',
            "/v1/e-commerce/payments/{$userData->uuid}/pay-by-payu/{$checkoutId}",
            $clientCredentials,
            [
                'json' => $payment,
            ]
        );

        return $this->serializer->deserialize(
            $response->getContent(false),
            PayByPayuOutput::class,
            'json'
        );
    }

}
