/** @type {import('tailwindcss').Config} */
export default {
  prefix: 'tw-',
  important: '#psfa-admin-root',
  content: [
    './core/**/*.php',
    './templates/**/*.php',
    './addons/**/*.php',
    './paapi-product-search-for-amazon.php',
  ],
  theme: {
    extend: {
      colors: {
        'brand': {
          'primary': '#2872FA',
          'hover': '#1559ed',
          'dark': '#111518',
          'gray': '#F6F7F9',
        },
      },
      fontFamily: {
        'rubik': ['Rubik', 'system-ui', 'sans-serif'],
      },
    },
  },
  plugins: [],
  corePlugins: {
    preflight: false,
  },
  // Only safelist classes toggled via JS that aren't in PHP templates
  // All other classes are found by scanning PHP files in content[]
  safelist: [],
}
