<?php
/**
 * Customization helper functions for premium features
 *
 * Handles custom colors, button customization, card layouts, and fonts
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render info icon with tooltip
 *
 * @param string $text Tooltip text
 * @return string HTML for info icon
 */
if (!function_exists('psfa_info_tip')) {
    function psfa_info_tip($text) {
        return sprintf(
            '<span class="psfa-info-tip dashicons dashicons-info-outline" title="%s" style="color: #2271b1; font-size: 16px; width: 16px; height: 16px; margin-left: 2px; cursor: help; vertical-align: super; display: inline-block;"></span>',
            esc_attr($text)
        );
    }
}

/**
 * Get custom button text
 *
 * @return string Button text
 */
function psfa_get_button_text() {
    
    return 'Buy on Amazon'; // Default in free build
}

/**
 * Get custom button style
 *
 * @return array Button style settings
 */
function psfa_get_button_style() {
    
    return array('border_radius' => '', 'font_size' => '', 'font_weight' => ''); // Default in free build
}

/**
 * Get custom colors for current theme
 *
 * @param string $theme Theme slug
 * @return array Color settings
 */
function psfa_get_theme_colors($theme) {
    
    return array(); // Default in free build
}

/**
 * Get selected card layout
 *
 * @return string Card layout type
 */
function psfa_get_card_layout() {
    
    return 'default'; // Default in free build
}

/**
 * Get custom font settings
 *
 * @return array Font settings
 */
function psfa_get_font_settings() {
    
    return array('title_font' => '', 'description_font' => '', 'price_font' => ''); // Default in free build
}

/**
 * Get default colors for a theme
 *
 * @param string $theme_slug Theme slug
 * @return array Default color values
 */
function psfa_get_theme_default_colors($theme_slug) {
    $defaults = array(
        'amazon-inspired' => array(
            'primary_color' => '#ff9900', // #f90 - orange used throughout
            'secondary_color' => '#666666', // #666 - Reset buttons color
            'button_bg' => '#f0c14b', // Button background gradient bottom color
            'button_text' => '#111', // Button text color
            'text_color' => '#111', // Product title/text color
            'price_color' => '#c45500', // Price color
            'amazon_icon_color' => '#111', // Amazon icon default color (black/dark - natural SVG color)
        ),
        'ocean-blue' => array(
            'primary_color' => '#2563eb',
            'secondary_color' => '#666666',
            'button_bg' => '#2563eb',
            'button_text' => '#ffffff',
            'text_color' => '#111',
            'price_color' => '#2563eb',
            'amazon_icon_color' => '#ffffff',
        ),
        'modern' => array(
            'primary_color' => '#667eea', // Used for search button, apply button (gradient start), price
            'secondary_color' => '#666666', // Used for reset buttons
            'button_bg' => '#667eea', // Button background (gradient start color)
            'button_text' => '#ffffff', // Button text color
            'text_color' => '#1f2937', // Product title/text color
            'price_color' => '#667eea', // Price color
            'amazon_icon_color' => '#ffffff', // Amazon icon default color
        ),
        'minimal' => array(
            'primary_color' => '#111111', // Used for search button, apply button, spinner
            'secondary_color' => '#6b7280', // Used for reset buttons
            'button_bg' => 'transparent', // Button has transparent background with border
            'button_text' => '#111111', // Button text color
            'text_color' => '#111111', // Product title/text color
            'price_color' => '#111111', // Price color
            'amazon_icon_color' => '#111111', // Amazon icon default color
        ),
        'dark' => array(
            'primary_color' => '#ff6b35', // Used for apply button, price, search button
            'secondary_color' => '#444444', // Used for reset buttons
            'button_bg' => '#ff6b35', // Button background color
            'button_text' => '#111111', // Button text color (dark)
            'text_color' => '#f9fafb', // Product title/text color
            'price_color' => '#ff6b35', // Price color
            'amazon_icon_color' => '#60a5fa', // Amazon icon default color
        ),
    );
    
    return isset($defaults[$theme_slug]) ? $defaults[$theme_slug] : array();
}

/**
 * Get premium feature settings
 *
 * @return array Feature toggle states
 */
function psfa_get_features() {
    $defaults = array(
        'deal_badge'       => true,
        'deal_countdown'   => true,
        'prime_exclusive'  => true,
        'low_stock'        => true,
        'buybox_winner'    => false,
        'used_price'       => false,
    );
    
    
    return $defaults;
}

/**
 * Check if a specific feature is enabled
 *
 * @param string $feature Feature key
 * @return bool True if enabled
 */
function psfa_is_feature_enabled($feature) {
    $features = psfa_get_features();
    return !empty($features[$feature]);
}

