<?php
/**
 * Core search functions for Amazon Product Search
 * Adapted for WordPress
 *
 * This file acts as a loader that includes all domain-specific modules.
 * This maintains backward compatibility with existing code that requires
 * this file, while allowing the codebase to be organized by domain.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load domain-specific modules in dependency order
require_once PSFA_PLUGIN_DIR . 'core/search/params.php';
require_once PSFA_PLUGIN_DIR . 'core/search/helpers.php';
require_once PSFA_PLUGIN_DIR . 'core/api/config.php';
require_once PSFA_PLUGIN_DIR . 'core/api/payload.php';
require_once PSFA_PLUGIN_DIR . 'core/api/http.php';
require_once PSFA_PLUGIN_DIR . 'core/search/core.php';
require_once PSFA_PLUGIN_DIR . 'core/search/result-processor.php';
require_once PSFA_PLUGIN_DIR . 'core/search/filter-builder.php';
require_once PSFA_PLUGIN_DIR . 'core/frontend/handler.php';
require_once PSFA_PLUGIN_DIR . 'core/search/view-helpers.php';
