<?php
/**
 * API Client Interface
 *
 * Defines contract for all API authentication strategies (AWS Sig V4, OAuth).
 * Follows Interface Segregation Principle - focused on PA-API operations.
 */

if (!defined('ABSPATH')) {
    exit;
}

interface PSFA_API_Client_Interface {

    /**
     * Execute a SearchItems request
     *
     * @param array $payload SearchItems payload (Keywords, SearchIndex, Resources, etc.)
     * @return array API response with SearchResult or error array
     */
    public function search_items(array $payload): array;

    /**
     * Execute a GetItems request
     *
     * @param array $asins List of ASINs to fetch
     * @param array $resources Resources to request
     * @return array API response with ItemsResult or error array
     */
    public function get_items(array $asins, array $resources): array;

    /**
     * Check if client is properly configured with valid credentials
     *
     * @return bool|WP_Error True if configured, WP_Error with message if not
     */
    public function is_configured();

    /**
     * Get client type identifier
     *
     * @return string 'awssig4' or 'oauth'
     */
    public function get_type(): string;

    /**
     * Get associate tag for this client
     *
     * @return string Associate tag or empty string if not configured
     */
    public function get_associate_tag(): string;
}
