<?php
/**
 * PA-API configuration and credentials
 *
 * Centralizes retrieval of PA-API credentials and endpoint configuration.
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Get PA-API configuration (live mode).
 *
 * Centralises access key / secret / associate tag and endpoint metadata so
 * psfa_amazon_search_products() does not have to know where they come from.
 *
 * @return array{error?:string, access_key?:string, secret_key?:string, associate_tag?:string, endpoint?:string, uri?:string, region?:string, service?:string, content_type?:string, amz_target?:string}
 */
function psfa_get_api_config() {
    // In mock mode, credentials are not required - data comes from mock.json
    if ( defined( 'PSFA_MOCK_MODE' ) && PSFA_MOCK_MODE ) {
        return array(
            'access_key'    => 'mock',
            'secret_key'    => 'mock',
            'associate_tag' => 'mock-20',
            'endpoint'      => 'webservices.amazon.com',
            'uri'           => '/paapi5/searchitems',
            'region'        => 'us-east-1',
            'service'       => 'ProductAdvertisingAPI',
            'content_type'  => 'application/json; charset=UTF-8',
            'amz_target'    => 'com.amazon.paapi5.v1.ProductAdvertisingAPIv1.SearchItems',
        );
    }

    $access_key    = get_option('psfa_access_key_id', '');
    $secret_key    = get_option('psfa_secret_access_key', '');
    $associate_tag = get_option('psfa_associate_tag', '');

    if (empty($access_key) || empty($secret_key) || empty($associate_tag)) {
        return array(
            'error' => 'AWS credentials not configured. Please set them in Settings → Paapi Product Search for Amazon.',
        );
    }

    return array(
        'access_key'    => $access_key,
        'secret_key'    => $secret_key,
        'associate_tag' => $associate_tag,
        'endpoint'      => 'webservices.amazon.com',
        'uri'           => '/paapi5/searchitems',
        'region'        => 'us-east-1',
        'service'       => 'ProductAdvertisingAPI',
        'content_type'  => 'application/json; charset=UTF-8',
        'amz_target'    => 'com.amazon.paapi5.v1.ProductAdvertisingAPIv1.SearchItems',
    );
}

