<?php
/**
 * Admin Themes tab renderer.
 *
 * Extracted from the main plugin class to keep responsibilities focused and
 * the main file smaller.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Render the Themes tab contents.
 */
function psfa_render_themes_tab() {
    // Preserve credentials and all customization settings when saving from themes tab
    $access_key = get_option('psfa_access_key_id', '');
    $secret_key = get_option('psfa_secret_access_key', '');
    $associate_tag = get_option('psfa_associate_tag', '');
    $button_text = get_option('psfa_button_text', 'Buy on Amazon');
    $button_border_radius = get_option('psfa_button_border_radius', '');
    $button_font_size = get_option('psfa_button_font_size', '');
    $button_font_weight = get_option('psfa_button_font_weight', '');
    $card_layout = get_option('psfa_card_layout', 'default');
    $title_font = get_option('psfa_title_font', '');
    $description_font = get_option('psfa_description_font', '');
    $price_font = get_option('psfa_price_font', '');
    $theme_colors = get_option('psfa_theme_colors', array());
    $display_mode = get_option('psfa_display_mode', 'grid');
    $hide_banner = get_option('psfa_hide_category_banner', false);
    $filter_visibility = get_option('psfa_filter_visibility', array(
        'brand' => true, 'price' => true, 'sort' => true, 'condition' => true,
        'merchant' => true, 'availability' => true, 'prime' => true, 'deals' => true,
    ));
    ?>
    <div class="psfa-tab-section">
        <h2 style="margin-top: 0;">Themes</h2>
        <p class="description">Customize the appearance of your Amazon product search. Premium themes are available for Pro/Premium users.</p>
        <form action="options.php" method="post">
            <?php 
            settings_fields( 'psfa_settings' );
            ?>
            <input type="hidden" name="psfa_access_key_id" value="<?php echo esc_attr($access_key); ?>">
            <input type="hidden" name="psfa_secret_access_key" value="<?php echo esc_attr($secret_key); ?>">
            <input type="hidden" name="psfa_associate_tag" value="<?php echo esc_attr($associate_tag); ?>">
            <input type="hidden" name="psfa_button_text" value="<?php echo esc_attr($button_text); ?>">
            <input type="hidden" name="psfa_button_border_radius" value="<?php echo esc_attr($button_border_radius); ?>">
            <input type="hidden" name="psfa_button_font_size" value="<?php echo esc_attr($button_font_size); ?>">
            <input type="hidden" name="psfa_button_font_weight" value="<?php echo esc_attr($button_font_weight); ?>">
            <input type="hidden" name="psfa_card_layout" value="<?php echo esc_attr($card_layout); ?>">
            <input type="hidden" name="psfa_title_font" value="<?php echo esc_attr($title_font); ?>">
            <input type="hidden" name="psfa_description_font" value="<?php echo esc_attr($description_font); ?>">
            <input type="hidden" name="psfa_price_font" value="<?php echo esc_attr($price_font); ?>">
            <input type="hidden" name="psfa_display_mode" value="<?php echo esc_attr($display_mode); ?>">
            <input type="hidden" name="psfa_hide_category_banner" value="<?php echo $hide_banner ? '1' : '0'; ?>">
            <?php foreach ($filter_visibility as $filter_key => $filter_val): ?>
            <input type="hidden" name="psfa_filter_visibility[<?php echo esc_attr($filter_key); ?>]" value="<?php echo $filter_val ? '1' : '0'; ?>">
            <?php endforeach; ?>
            <?php if (!empty($theme_colors)): ?>
                <?php foreach ($theme_colors as $theme_slug => $colors): ?>
                    <?php foreach ($colors as $color_key => $color_value): ?>
                        <input type="hidden" name="psfa_theme_colors[<?php echo esc_attr($theme_slug); ?>][<?php echo esc_attr($color_key); ?>]" value="<?php echo esc_attr($color_value); ?>">
                    <?php endforeach; ?>
                <?php endforeach; ?>
            <?php endif; ?>
            <div class="psfa-themes-wrapper">
                <?php psfa_render_theme_selection(); ?>
            </div>
            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #ddd;">
                <?php 
                if ( function_exists( 'submit_button' ) ) {
                    submit_button( 'Save Settings', 'primary', 'submit', false );
                } else {
                    echo '<input type="submit" name="submit" class="button button-primary" value="Save Settings">';
                }
                ?>
                <a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array(
                    'page'                    => 'paapi-product-search-for-amazon',
                    'tab'                     => 'themes',
                    'psfa_reset_customization' => '1',
                ), admin_url( 'admin.php' ) ), 'psfa_reset_customization' ) ); ?>" class="button button-secondary" style="margin-left: 10px;" onclick="return confirm('Are you sure you want to reset all theme settings to their defaults?');">Reset to Defaults</a>
            </div>
        </form>
    </div>
    <?php
}

/**
 * Render theme selection interface.
 */
function psfa_render_theme_selection() {
    require_once PSFA_PLUGIN_DIR . 'core/shared/theme-manager.php';
    require_once PSFA_PLUGIN_DIR . 'core/search/view-helpers.php';
    
    $themes = psfa_get_all_themes();
    $selected = psfa_get_selected_theme();
    
    // Default values for free build
    $is_premium = false;
    $upgrade_url = 'https://paapiplugin.com/pricing/#plans';
    
    
    
    // Map theme slugs to preview image filenames
    $theme_previews = array(
        'amazon-inspired' => 'amazon-inspired.png',
        'ocean-blue' => 'ocean-blue.png',
        'modern' => 'modern.png',
        'minimal' => 'minimal.png',
        'dark' => 'dark.png',
    );
    
    echo '<div class="psfa-theme-selector" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(260px, 1fr)); gap: 20px;">';
    foreach ($themes as $slug => $theme) {
        // Determine availability - free users can only use non-premium themes
        $is_available = !$theme['premium'] || $is_premium;
        $premium_badge = $theme['premium'] ? ' <span class="psfa-badge-premium-small">Premium</span>' : ' <span class="psfa-badge-free-small">Free</span>';
        $checked = ($slug === $selected) ? 'checked' : '';
        $preview_image = isset($theme_previews[$slug]) ? PSFA_PLUGIN_URL . 'assets/img/' . $theme_previews[$slug] : '';
        $border_style = ($slug === $selected && $is_available) ? 'border: 2px solid #2271b1; box-shadow: 0 2px 8px rgba(34, 113, 177, 0.2); background: #f0f6fc;' : 'border: 1px solid #ddd; background: #fff;';
        
        echo '<div class="psfa-theme-card" style="' . esc_attr( $border_style ) . ' border-radius: 8px; padding: 16px; transition: all 0.3s ease;">';
        
        // Preview image (thumbnail)
        if ($preview_image) {
            echo '<div style="margin-bottom: 10px; border: 1px solid #ddd; border-radius: 4px; overflow: hidden; background: #f0f0f1; cursor: pointer; display: flex; align-items: center; justify-content: center;" class="psfa-theme-preview-wrapper">';
            echo '<img src="' . esc_url($preview_image) . '" alt="' . esc_attr($theme['name']) . ' Preview" class="psfa-theme-preview-img" data-full-image="' . esc_url($preview_image) . '" style="max-width: 100%; max-height: 100%; display: block; transition: opacity 0.2s;">';
            echo '</div>';
        }
        
        if ($is_available) {
            // Available theme - show selectable radio button
            echo '<label style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px; cursor: pointer;">';
            echo '<div>';
            echo '<input type="radio" name="psfa_selected_theme" value="' . esc_attr($slug) . '" ' . esc_attr( $checked ) . ' style="margin-right: 8px; margin-top: 0;">';
            echo '<strong style="font-size: 14px;">' . esc_html($theme['name']) . '</strong>';
            echo '<span style="margin-left: 5px;">' . wp_kses_post( $premium_badge ) . '</span>';
            echo '</div>';
            if ($preview_image) {
                echo '<button type="button" class="button button-small psfa-theme-preview-button" data-full-image="' . esc_url( $preview_image ) . '" style="display: inline-flex; align-items: center; gap: 4px;">';
                echo '<span class="dashicons dashicons-visibility"></span> Preview';
                echo '</button>';
            }
            echo '</label>';
            echo '<p class="description" style="margin: 0 0 10px 24px; font-size: 13px; color: #646970;">' . esc_html($theme['description']) . '</p>';
        } else {
            // Premium theme not available - show as preview card (no disabled controls)
            echo '<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">';
            echo '<div>';
            echo '<strong style="font-size: 14px;">' . esc_html($theme['name']) . '</strong>';
            echo '<span style="margin-left: 5px;">' . wp_kses_post( $premium_badge ) . '</span>';
            echo '</div>';
            if ($preview_image) {
                echo '<button type="button" class="button button-small psfa-theme-preview-button" data-full-image="' . esc_url( $preview_image ) . '" style="display: inline-flex; align-items: center; gap: 4px;">';
                echo '<span class="dashicons dashicons-visibility"></span> Preview';
                echo '</button>';
            }
            echo '</div>';
            echo '<p class="description" style="margin: 0 0 10px 0; font-size: 13px; color: #646970;">' . esc_html($theme['description']) . '</p>';
            echo '<div style="margin-top: 10px; padding: 8px 12px; background: #fff3cd; border-left: 3px solid #ffc107; border-radius: 3px;">';
            echo '<span class="description" style="font-size: 12px; color: #856404;">';
            echo '<a href="' . esc_url($upgrade_url) . '" target="_blank" style="color: #2271b1; text-decoration: none; font-weight: 600;">Upgrade to Premium</a> to unlock this theme.';
            echo '</span>';
            echo '</div>';
        }
        
        echo '</div>';
    }
    echo '</div>';
    // Note: Lightbox CSS is in styles.php, JS is enqueued via wp_add_inline_script in main plugin file
}

