<?php
/**
 * Admin inline styles for the plugin settings page.
 *
 * Extracted from the main plugin file to keep responsibilities focused and
 * improve maintainability.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Get admin inline CSS for the settings page.
 *
 * @return string
 */
function psfa_get_admin_styles() {
    return '
        .psfa-badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            margin-left: 8px;
        }
        .psfa-badge-premium {
            background: #2271b1;
            color: white;
        }
        .psfa-badge-free {
            background: #f0f0f1;
            color: #50575e;
        }
        .psfa-badge-premium-small {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: 600;
            background: #2271b1;
            color: white;
            margin-left: 6px;
        }
        .psfa-badge-free-small {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: 600;
            background: #f0f0f1;
            color: #50575e;
            margin-left: 6px;
        }
        .psfa-theme-preview-button {
            display: inline-flex;
            align-items: center;
            gap: 4px;
            padding: 2px 8px;
            border-radius: 3px;
            border: 1px solid #2271b1;
            background: #f6f7f7;
            color: #2271b1;
            font-size: 12px;
            cursor: pointer;
            text-decoration: none;
        }
        .psfa-theme-preview-button .dashicons {
            font-size: 14px;
            width: 14px;
            height: 14px;
        }
        .psfa-theme-preview-button:hover {
            background: #f0f6fc;
            border-color: #1b5f8d;
            color: #1b5f8d;
        }
        /* Frontend demo panel: override theme button styles */
        .psfa-demo-content .psfa-theme-preview-button {
            display: none !important;
        }
        .psfa-feature-card {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            background: #fff;
        }
        .psfa-feature-header {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 12px;
        }
        .psfa-feature-icon {
            font-size: 24px;
            line-height: 1;
            color: #2271b1;
            width: 24px;
            height: 24px;
        }
        .psfa-feature-header h3 {
            margin: 0;
            padding: 0;
            font-size: 18px;
            font-weight: 600;
            flex: 1;
            color: #2271b1;
        }
        .psfa-feature-action {
            margin-top: 15px;
        }
        .psfa-feature-active {
            color: #00a32a;
            font-weight: 600;
        }
        .psfa-upgrade-prompt {
            margin-top: 10px;
            padding: 10px;
            background: #fff3cd;
            border-left: 4px solid #ffc107;
        }
        .psfa-tab-section {
            margin: 20px 0;
        }
        .psfa-tab-section h2 {
            margin-top: 0;
            margin-bottom: 10px;
            font-size: 23px;
            font-weight: 400;
            line-height: 1.3;
        }
        .psfa-tab-section .description {
            margin-bottom: 20px;
            font-size: 14px;
            color: #646970;
        }
        .psfa-credentials-card {
            background: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }
        .psfa-credential-field {
            margin-bottom: 25px;
        }
        .psfa-credential-field:last-child {
            margin-bottom: 0;
        }
        .psfa-field-label {
            display: block;
            font-weight: 600;
            margin-bottom: 8px;
            font-size: 14px;
            color: #1d2327;
        }
        .psfa-field-input-wrapper input[type=\"text\"],
        .psfa-field-input-wrapper input[type=\"password\"] {
            width: 100%;
            max-width: 500px;
            padding: 8px 12px;
            border: 1px solid #8c8f94;
            border-radius: 4px;
            font-size: 14px;
            line-height: 1.5;
            transition: border-color 0.2s;
        }
        .psfa-field-input-wrapper input[type=\"text\"]:focus,
        .psfa-field-input-wrapper input[type=\"password\"]:focus {
            border-color: #2271b1;
            box-shadow: 0 0 0 1px #2271b1;
            outline: none;
        }
        .psfa-themes-wrapper {
            margin-top: 20px;
        }
        .psfa-theme-card {
            transition: all 0.3s ease;
        }
        .psfa-theme-card:hover {
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
        .psfa-theme-card.psfa-theme-selected {
            border-color: #2271b1 !important;
            box-shadow: 0 2px 8px rgba(34, 113, 177, 0.2) !important;
            background: #f0f6fc !important;
        }
        .psfa-layout-selection {
            margin: 20px 0;
        }
        .psfa-layout-options {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }
        .psfa-layout-card {
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            background: #fff;
            transition: all 0.3s ease;
            position: relative;
        }
        .psfa-layout-card:hover:not(.psfa-layout-disabled) {
            border-color: #2271b1;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
        .psfa-layout-card.psfa-layout-selected {
            border-color: #2271b1;
            background: #f0f6fc;
            box-shadow: 0 2px 8px rgba(34, 113, 177, 0.2);
        }
        .psfa-layout-card.psfa-layout-disabled {
            cursor: not-allowed;
        }
        .psfa-layout-label {
            display: block;
            cursor: pointer;
            margin: 0;
            position: relative;
            height: 100%;
        }
        .psfa-layout-card.psfa-layout-disabled .psfa-layout-label {
            display: none;
        }
        .psfa-layout-radio {
            position: absolute;
            bottom: 20px;
            left: 20px;
        }
        .psfa-layout-content {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }
        .psfa-layout-header {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .psfa-layout-icon {
            /* Match feature card icon sizing */
            font-size: 24px;
            line-height: 1;
            color: #2271b1;
            width: 24px;
            height: 24px;
            display: inline-block;
        }
        .psfa-layout-card.psfa-layout-selected .psfa-layout-icon {
            color: #135e96;
        }
        .psfa-layout-header h3 {
            margin: 0;
            font-size: 18px;
            color: #2271b1 !important;
            font-weight: 600;
            flex: 1;
        }
        .psfa-layout-description {
            margin: 0;
            color: #646970;
            font-size: 14px;
            line-height: 1.5;
        }
        .psfa-customization-wrapper {
            margin-top: 20px;
        }
        .psfa-customization-section {
            background: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 25px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }
        .psfa-customization-section .psfa-layout-header {
            margin-bottom: 12px;
        }
        .psfa-customization-section .psfa-layout-header h3 {
            color: #2271b1;
        }
        .psfa-customization-section .description {
            margin-bottom: 15px;
            color: #646970;
            font-size: 14px;
        }
        .psfa-customization-section .form-table {
            margin-top: 0;
        }
        .psfa-customization-section .form-table th {
            padding-left: 0;
            font-weight: 500;
            text-align: left;
            vertical-align: middle;
            width: 40%;
        }
        .psfa-customization-section .form-table td {
            padding-left: 0;
            text-align: right;
            vertical-align: middle;
            width: 60%;
        }
        .psfa-customization-section .form-table td input[type="text"],
        .psfa-customization-section .form-table td input[type="number"],
        .psfa-customization-section .form-table td select {
            float: right;
            margin-left: 10px;
            max-width: 260px;
            width: 100%;
            box-sizing: border-box;
        }
        .psfa-customization-section .form-table td input.regular-text {
            max-width: 360px;
        }
        .psfa-customization-section .form-table td input.small-text {
            max-width: 120px;
        }
        .psfa-customization-section .form-table td .wp-picker-container {
            float: right;
            margin-left: 10px;
        }
        .psfa-category-list {
            display: flex !important;
            flex-wrap: wrap;
            gap: 5px;
            margin: 5px 0 0;
            list-style: none;
            padding: 0;
        }
        .psfa-category-item {
            display: list-item;
            margin: 0;
            padding-left: 15px;
            position: relative;
        }
        .psfa-category-checkmark {
            position: absolute;
            left: 0;
            color: #00a32a;
        }
        .psfa-category-free-badge {
            color: #666;
            font-size: 0.9em;
        }
        /* Theme preview lightbox styles */
        .psfa-theme-preview-wrapper {
            position: relative;
        }
        .psfa-theme-preview-img {
            cursor: pointer;
        }
        .psfa-theme-preview-img:hover {
            opacity: 0.8;
        }
        .psfa-admin-lightbox {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 100000;
            background: rgba(0, 0, 0, 0.9);
            cursor: pointer;
        }
        .psfa-admin-lightbox.active {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .psfa-admin-lightbox-content {
            position: relative;
            max-width: 90%;
            max-height: 90%;
            cursor: default;
        }
        .psfa-admin-lightbox-content img {
            max-width: 100%;
            max-height: 90vh;
            object-fit: contain;
            border-radius: 4px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.5);
        }
        .psfa-admin-lightbox-close {
            position: absolute;
            top: -20px;
            right: -20px;
            background: rgba(255, 255, 255, 0.9);
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            font-size: 24px;
            line-height: 40px;
            cursor: pointer;
            color: #333;
            display: flex;
            align-items: normal;
            justify-content: center;
            transition: background 0.2s;
            padding: 0;
            margin: 0;
            text-align: center;
        }
        .psfa-admin-lightbox-close:hover {
            background: rgba(255, 255, 255, 1);
        }
    ';
}

/**
 * Get admin inline JavaScript for the settings page.
 *
 * @return string
 */
function psfa_get_admin_scripts() {
    return '
(function() {
    var lightbox, lightboxImg, closeBtn, lightboxContent;
    
    function initLightbox() {
        if (lightbox) return; // Already initialized
        if (!document.body) return; // Body not ready
        
        // Theme preview lightbox
        lightbox = document.createElement("div");
        lightbox.className = "psfa-admin-lightbox";
        lightbox.innerHTML = \'<div class="psfa-admin-lightbox-content"><button class="psfa-admin-lightbox-close" aria-label="Close">&times;</button><img src="" alt="Theme Preview"></div>\';
        document.body.appendChild(lightbox);
        
        lightboxImg = lightbox.querySelector("img");
        closeBtn = lightbox.querySelector(".psfa-admin-lightbox-close");
        lightboxContent = lightbox.querySelector(".psfa-admin-lightbox-content");
        
        lightbox.addEventListener("click", function(e) {
            if (e.target === lightbox) {
                closeLightbox();
            }
        });
        
        closeBtn.addEventListener("click", closeLightbox);
        
        lightboxContent.addEventListener("click", function(e) {
            e.stopPropagation();
        });
    }
    
    function openLightbox(imgSrc) {
        initLightbox();
        if (!lightbox) return;
        lightboxImg.src = imgSrc;
        lightbox.classList.add("active");
        document.body.style.overflow = "hidden";
    }
    
    function closeLightbox() {
        if (!lightbox) return;
        lightbox.classList.remove("active");
        document.body.style.overflow = "";
    }
    
    document.addEventListener("keydown", function(e) {
        if (e.key === "Escape" && lightbox && lightbox.classList.contains("active")) {
            closeLightbox();
        }
    });
    
    document.addEventListener("DOMContentLoaded", function() {
        initLightbox();
        // Theme preview images
        var previewImages = document.querySelectorAll(".psfa-theme-preview-img");
        previewImages.forEach(function(img) {
            var wrapper = img.closest(".psfa-theme-preview-wrapper");
            var card = img.closest(".psfa-theme-card");
            var radio = card ? card.querySelector("input[type=\"radio\"][name=\"psfa_selected_theme\"]") : null;

            function handleClick(e) {
                e.preventDefault();
                if (radio && !radio.disabled) {
                    radio.checked = true;
                    radio.dispatchEvent(new Event("change", { bubbles: true }));
                }
            }

            img.addEventListener("click", handleClick);
            if (wrapper) {
                wrapper.addEventListener("click", handleClick);
            }
        });

        // Preview buttons: open lightbox with full-size image
        var previewButtons = document.querySelectorAll(".psfa-theme-preview-button");
        previewButtons.forEach(function(button) {
            button.addEventListener("click", function(e) {
                e.preventDefault();
                var fullImage = button.getAttribute("data-full-image");
                if (fullImage) {
                    openLightbox(fullImage);
                }
            });
        });

        // Layout card selection
        var cards = document.querySelectorAll(".psfa-layout-card:not(.psfa-layout-disabled)");
        var radios = document.querySelectorAll(".psfa-layout-radio");

        function updateSelectedState() {
            var checkedRadio = document.querySelector(".psfa-layout-radio:checked");
            var selectedValue = checkedRadio ? checkedRadio.value : null;
            document.querySelectorAll(".psfa-layout-card").forEach(function(card) {
                card.classList.remove("psfa-layout-selected");
            });
            if (!selectedValue) return;
            var cardInput = document.querySelector(".psfa-layout-card input.psfa-layout-radio[value=\"" + selectedValue + "\"]");
            if (cardInput) {
                var wrapper = cardInput.closest(".psfa-layout-card");
                if (wrapper) {
                    wrapper.classList.add("psfa-layout-selected");
                }
            }
        }

        cards.forEach(function(card) {
            card.addEventListener("click", function(e) {
                var radio = card.querySelector(".psfa-layout-radio");
                if (!radio || radio.disabled) return;
                if (e.target === radio) return;
                radio.checked = true;
                radio.dispatchEvent(new Event("change", { bubbles: true }));
            });
        });

        radios.forEach(function(radio) {
            radio.addEventListener("change", updateSelectedState);
        });

        updateSelectedState();
    });
})();
';
}


