<?php
/**
 * Admin Shortcode Builder Tab
 *
 * Provides a visual shortcode builder for site administrators.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Render the Shortcode Builder tab contents.
 */
function psfa_render_shortcode_tab() {
    require_once PSFA_PLUGIN_DIR . 'core/search/view-helpers.php';
    require_once PSFA_PLUGIN_DIR . 'core/shared/customization-helpers.php';
    $is_premium = psfa_is_premium();
    
    // Define categories - free users only see 5
    $free_categories = array(
        'Electronics' => 'Electronics',
        'Books' => 'Books',
        'Fashion' => 'Fashion',
        'ToysAndGames' => 'Toys & Games',
        'HomeAndGarden' => 'Home & Garden',
    );
    
    $premium_categories = array(
        'OfficeProducts' => 'Office Products',
        'VideoGames' => 'Video Games',
        'MusicalInstruments' => 'Musical Instruments',
        'Automotive' => 'Automotive',
        'Baby' => 'Baby',
        'Beauty' => 'Beauty',
        'Computers' => 'Computers',
        'HealthPersonalCare' => 'Health & Personal Care',
        'KindleStore' => 'Kindle Store',
        'MoviesAndTV' => 'Movies & TV',
        'Music' => 'Music',
        'PetSupplies' => 'Pet Supplies',
        'Software' => 'Software',
        'SportsAndOutdoors' => 'Sports & Outdoors',
        'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
    );
    
    $categories = $is_premium ? array_merge($free_categories, $premium_categories) : $free_categories;
    ?>
    <div class="psfa-tab-section">
        <h2 style="margin-top: 0;">Shortcode Builder</h2>
        <p class="description">Build your shortcode by selecting options below. Copy the generated shortcode and paste it into any page or post.</p>
        
        <div class="psfa-customization-wrapper" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 20px; margin-top: 20px;">
            
            <!-- Search & Content Options -->
            <div class="psfa-customization-section">
                <div class="psfa-layout-header">
                    <span class="psfa-layout-icon dashicons dashicons-search"></span>
                    <h3>Search & Content</h3>
                    <span class="psfa-badge-free-small">Free</span>
                </div>
                <p class="description">Configure default search query and category.</p>
                <table class="form-table">
                    <tr>
                        <th scope="row">Default Query <?php echo wp_kses_post( psfa_info_tip('Pre-fills the search box with this text when the page loads. Users can still modify or clear it.') ); ?></th>
                        <td>
                            <input type="text" id="psfa-sc-query" class="regular-text" placeholder="e.g., laptop, headphones">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Category <?php echo wp_kses_post( psfa_info_tip('Restricts search results to a specific Amazon category. Leave empty to search all categories.') ); ?></th>
                        <td>
                            <select id="psfa-sc-category">
                                <option value="">-- Default (All) --</option>
                                <?php foreach ($categories as $value => $label) : ?>
                                    <option value="<?php echo esc_attr($value); ?>"><?php echo esc_html($label); ?></option>
                                <?php endforeach; ?>
                            </select>
                            <?php if (!$is_premium) : 
                                $upgrade_url = 'https://paapiplugin.com/pricing/#plans';
                            ?>
                                <div style="margin-top: 8px; float: right; padding: 8px; background: #fff3cd; border-left: 3px solid #ffc107; border-radius: 3px;">
                                    <span class="description" style="font-size: 12px; color: #856404;">
                                        <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" style="color: #2271b1; text-decoration: none; font-weight: 600;">Upgrade to Premium</a> to access all 26 categories.
                                    </span>
                                </div>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Brand <?php echo wp_kses_post( psfa_info_tip('Filter results to show only products from this brand. Works best when combined with a category.') ); ?></th>
                        <td>
                            <input type="text" id="psfa-sc-brand" class="regular-text" placeholder="e.g., Apple, Samsung">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Sort By <?php echo wp_kses_post( psfa_info_tip('Default sort order for search results. Users can still change this using the sort dropdown.') ); ?></th>
                        <td>
                            <select id="psfa-sc-sort">
                                <option value="">-- Default --</option>
                                <option value="Relevance">Relevance</option>
                                <option value="Price:LowToHigh">Price: Low to High</option>
                                <option value="Price:HighToLow">Price: High to Low</option>
                                <option value="NewestArrivals">Newest Arrivals</option>
                                <option value="AvgCustomerReviews">Customer Reviews</option>
                                <option value="Featured">Featured</option>
                            </select>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Display Options -->
            <div class="psfa-customization-section">
                <div class="psfa-layout-header">
                    <span class="psfa-layout-icon dashicons dashicons-visibility"></span>
                    <h3>Display Options</h3>
                    <span class="psfa-badge-free-small">Free</span>
                </div>
                <p class="description">Control visibility and pagination behavior.</p>
                <table class="form-table">
                    <tr>
                        <th scope="row">Pagination <?php echo wp_kses_post( psfa_info_tip('Controls how additional products are loaded. Infinite scroll loads automatically, Button requires user click, None shows only initial results.') ); ?></th>
                        <td>
                            <select id="psfa-sc-pagination">
                                <option value="">-- Default (infinite) --</option>
                                <option value="infinite">Infinite Scroll</option>
                                <option value="button">Load More Button</option>
                                <option value="none">No Pagination</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Visibility <?php echo wp_kses_post( psfa_info_tip('Control which UI elements are shown to users.') ); ?></th>
                        <td>
                            <fieldset>
                                <label style="display: block; margin-bottom: 8px;">
                                    <input type="checkbox" id="psfa-sc-hide-search">
                                    Hide Search Box <?php echo wp_kses_post( psfa_info_tip('Hides the search input. Useful for curated product displays with pre-set query.') ); ?>
                                </label>
                                <label style="display: block; margin-bottom: 8px;">
                                    <input type="checkbox" id="psfa-sc-hide-filters">
                                    Hide Filters <?php echo wp_kses_post( psfa_info_tip('Hides the filter sidebar (brand, price, condition). Products still display normally.') ); ?>
                                </label>
                                <label style="display: block;">
                                    <input type="checkbox" id="psfa-sc-auto-detect" checked>
                                    Auto-detect Category <?php echo wp_kses_post( psfa_info_tip('Automatically detects category from page content (title, headings). Disable if you want full control.') ); ?>
                                </label>
                            </fieldset>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <!-- Generated Shortcode (full width) -->
        <div class="psfa-customization-section" style="margin-top: 20px;">
            <div class="psfa-layout-header">
                <span class="psfa-layout-icon dashicons dashicons-shortcode"></span>
                <h3>Generated Shortcode</h3>
            </div>
            <p class="description">Copy this shortcode and paste it into any page or post.</p>
            <div style="display: flex; gap: 10px; align-items: center; margin-top: 15px;">
                <code id="psfa-sc-output" style="flex: 1; padding: 12px 15px; background: #f6f7f7; border: 1px solid #c3c4c7; border-radius: 4px; font-size: 13px; word-break: break-all;">[psfa_search]</code>
                <button type="button" id="psfa-sc-copy" class="button button-primary">
                    <span class="dashicons dashicons-clipboard" style="vertical-align: middle; margin-right: 4px;"></span> Copy
                </button>
            </div>
            <p id="psfa-sc-copy-feedback" style="color: #00a32a; margin: 10px 0 0; font-size: 13px;"></p>
        </div>
        
        <!-- Usage Examples -->
        <div class="psfa-customization-section" style="margin-top: 20px; background: #fff8e5; border-left: 4px solid #dba617;">
            <div class="psfa-layout-header">
                <span class="psfa-layout-icon dashicons dashicons-lightbulb"></span>
                <h3>Usage Examples</h3>
            </div>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 15px; margin-top: 10px;">
                <div>
                    <strong>Basic:</strong><br>
                    <code style="font-size: 12px;">[psfa_search]</code>
                </div>
                <div>
                    <strong>Pre-filled search:</strong><br>
                    <code style="font-size: 12px;">[psfa_search query="wireless headphones"]</code>
                </div>
                <div>
                    <strong>Category page:</strong><br>
                    <code style="font-size: 12px;">[psfa_search category="Electronics" hide_search="true"]</code>
                </div>
                <div>
                    <strong>Product listing:</strong><br>
                    <code style="font-size: 12px;">[psfa_search query="iphone" hide_search="true" hide_filters="true"]</code>
                </div>
            </div>
        </div>
    </div>
    
    <script type="text/javascript">
    (function() {
        var scQuery = document.getElementById('psfa-sc-query');
        var scCategory = document.getElementById('psfa-sc-category');
        var scBrand = document.getElementById('psfa-sc-brand');
        var scSort = document.getElementById('psfa-sc-sort');
        var scPagination = document.getElementById('psfa-sc-pagination');
        var scHideSearch = document.getElementById('psfa-sc-hide-search');
        var scHideFilters = document.getElementById('psfa-sc-hide-filters');
        var scAutoDetect = document.getElementById('psfa-sc-auto-detect');
        var scOutput = document.getElementById('psfa-sc-output');
        var scCopyBtn = document.getElementById('psfa-sc-copy');
        var scCopyFeedback = document.getElementById('psfa-sc-copy-feedback');

        function generateShortcode() {
            if (!scOutput) return;
            
            var attrs = [];
            
            if (scQuery && scQuery.value.trim()) {
                attrs.push('query="' + scQuery.value.trim() + '"');
            }
            if (scCategory && scCategory.value) {
                attrs.push('category="' + scCategory.value + '"');
            }
            if (scBrand && scBrand.value.trim()) {
                attrs.push('brand="' + scBrand.value.trim() + '"');
            }
            if (scSort && scSort.value) {
                attrs.push('sort="' + scSort.value + '"');
            }
            if (scPagination && scPagination.value) {
                attrs.push('pagination="' + scPagination.value + '"');
            }
            if (scHideSearch && scHideSearch.checked) {
                attrs.push('hide_search="true"');
            }
            if (scHideFilters && scHideFilters.checked) {
                attrs.push('hide_filters="true"');
            }
            if (scAutoDetect && !scAutoDetect.checked) {
                attrs.push('auto_detect="no"');
            }
            
            var shortcode = '[psfa_search';
            if (attrs.length > 0) {
                shortcode += ' ' + attrs.join(' ');
            }
            shortcode += ']';
            
            scOutput.textContent = shortcode;
        }

        // Attach event listeners
        var inputs = [scQuery, scCategory, scBrand, scSort, scPagination, scHideSearch, scHideFilters, scAutoDetect];
        inputs.forEach(function(el) {
            if (el) {
                el.addEventListener('input', generateShortcode);
                el.addEventListener('change', generateShortcode);
            }
        });

        // Copy to clipboard
        if (scCopyBtn && scOutput) {
            scCopyBtn.addEventListener('click', function() {
                var text = scOutput.textContent;
                navigator.clipboard.writeText(text).then(function() {
                    if (scCopyFeedback) {
                        scCopyFeedback.textContent = 'Copied to clipboard!';
                        setTimeout(function() {
                            scCopyFeedback.textContent = '';
                        }, 2000);
                    }
                }).catch(function() {
                    // Fallback for older browsers
                    var textArea = document.createElement('textarea');
                    textArea.value = text;
                    document.body.appendChild(textArea);
                    textArea.select();
                    document.execCommand('copy');
                    document.body.removeChild(textArea);
                    if (scCopyFeedback) {
                        scCopyFeedback.textContent = 'Copied to clipboard!';
                        setTimeout(function() {
                            scCopyFeedback.textContent = '';
                        }, 2000);
                    }
                });
            });
        }
    })();
    </script>
    <?php
}
