<?php
if (!defined('ABSPATH')) exit;

/**
 * Render themes section with Tailwind styling
 */
function psfa_render_themes($is_premium) {
    require_once PSFA_PLUGIN_DIR . 'core/shared/theme-manager.php';
    
    $themes = psfa_get_all_themes();
    $selected = psfa_get_selected_theme();
    $upgrade_url = 'https://paapiplugin.com/pricing/#plans';
    
    
    
    // Preserve other settings - API credentials
    $auth_type = get_option('psfa_auth_type', 'awssig4');
    $access_key = get_option('psfa_access_key_id', '');
    $secret_key = get_option('psfa_secret_access_key', '');
    $associate_tag = get_option('psfa_associate_tag', '');
    $oauth_client_id = get_option('psfa_oauth_client_id', '');
    $oauth_client_secret = get_option('psfa_oauth_client_secret', '');
    $oauth_credential_version = get_option('psfa_oauth_credential_version', '');
    $oauth_auth_region = get_option('psfa_oauth_auth_region', 'us-east-1');
    $marketplace = get_option('psfa_marketplace', 'www.amazon.com');
    $button_text = get_option('psfa_button_text', 'Buy on Amazon');
    $button_border_radius = get_option('psfa_button_border_radius', '');
    $button_font_size = get_option('psfa_button_font_size', '');
    $button_font_weight = get_option('psfa_button_font_weight', '');
    $card_layout = get_option('psfa_card_layout', 'default');
    $title_font = get_option('psfa_title_font', '');
    $description_font = get_option('psfa_description_font', '');
    $price_font = get_option('psfa_price_font', '');
    $theme_colors = get_option('psfa_theme_colors', array());
    $display_mode = get_option('psfa_display_mode', 'grid');
    $hide_banner = get_option('psfa_hide_category_banner', false);
    $hide_search = in_array(get_option('psfa_hide_search', '0'), array('1', 1, true, 'true'), true);
    $hide_filters = in_array(get_option('psfa_hide_filters', '0'), array('1', 1, true, 'true'), true);
    $filter_visibility = get_option('psfa_filter_visibility', array(
        'brand' => true, 'price' => true, 'sort' => true, 'condition' => true,
        'merchant' => true, 'availability' => true, 'has_deal' => true, 'deals' => true,
    ));
    
    // Theme preview images
    $theme_previews = array(
        'amazon-inspired' => 'amazon-inspired.png',
        'ocean-blue' => 'ocean-blue.png',
        'modern' => 'modern.png',
        'minimal' => 'minimal.png',
        'dark' => 'dark.png',
    );
    ?>
    <form action="options.php" method="post">
        <?php settings_fields('psfa_settings'); ?>
        
        <!-- Hidden fields to preserve settings -->
        <input type="hidden" name="psfa_auth_type" value="<?php echo esc_attr($auth_type); ?>">
        <input type="hidden" name="psfa_access_key_id" value="<?php echo esc_attr($access_key); ?>">
        <input type="hidden" name="psfa_secret_access_key" value="<?php echo esc_attr($secret_key); ?>">
        <input type="hidden" name="psfa_associate_tag" value="<?php echo esc_attr($associate_tag); ?>">
        <input type="hidden" name="psfa_oauth_client_id" value="<?php echo esc_attr($oauth_client_id); ?>">
        <input type="hidden" name="psfa_oauth_client_secret" value="<?php echo esc_attr($oauth_client_secret); ?>">
        <input type="hidden" name="psfa_oauth_credential_version" value="<?php echo esc_attr($oauth_credential_version); ?>">
        <input type="hidden" name="psfa_oauth_auth_region" value="<?php echo esc_attr($oauth_auth_region); ?>">
        <input type="hidden" name="psfa_marketplace" value="<?php echo esc_attr($marketplace); ?>">
        <input type="hidden" name="psfa_button_text" value="<?php echo esc_attr($button_text); ?>">
        <input type="hidden" name="psfa_button_border_radius" value="<?php echo esc_attr($button_border_radius); ?>">
        <input type="hidden" name="psfa_button_font_size" value="<?php echo esc_attr($button_font_size); ?>">
        <input type="hidden" name="psfa_button_font_weight" value="<?php echo esc_attr($button_font_weight); ?>">
        <input type="hidden" name="psfa_card_layout" value="<?php echo esc_attr($card_layout); ?>">
        <input type="hidden" name="psfa_title_font" value="<?php echo esc_attr($title_font); ?>">
        <input type="hidden" name="psfa_description_font" value="<?php echo esc_attr($description_font); ?>">
        <input type="hidden" name="psfa_price_font" value="<?php echo esc_attr($price_font); ?>">
        <input type="hidden" name="psfa_display_mode" value="<?php echo esc_attr($display_mode); ?>">
        <input type="hidden" name="psfa_hide_category_banner" value="<?php echo $hide_banner ? '1' : '0'; ?>">
        <input type="hidden" name="psfa_hide_search" value="<?php echo $hide_search ? '1' : '0'; ?>">
        <input type="hidden" name="psfa_hide_filters" value="<?php echo $hide_filters ? '1' : '0'; ?>">
        <?php foreach ($filter_visibility as $filter_key => $filter_val): ?>
        <input type="hidden" name="psfa_filter_visibility[<?php echo esc_attr($filter_key); ?>]" value="<?php echo $filter_val ? '1' : '0'; ?>">
        <?php endforeach; ?>
        <?php 
        // Preserve features settings
        $saved_features = get_option('psfa_features', array());
        foreach ($saved_features as $fkey => $fval): ?>
        <input type="hidden" name="psfa_features[<?php echo esc_attr($fkey); ?>]" value="<?php echo $fval ? '1' : '0'; ?>">
        <?php endforeach; ?>
        <?php if (!empty($theme_colors)): ?>
            <?php foreach ($theme_colors as $theme_slug => $colors): ?>
                <?php foreach ($colors as $color_key => $color_value): ?>
                    <input type="hidden" name="psfa_theme_colors[<?php echo esc_attr($theme_slug); ?>][<?php echo esc_attr($color_key); ?>]" value="<?php echo esc_attr($color_value); ?>">
                <?php endforeach; ?>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <!-- Theme Cards Grid -->
        <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-2 lg:tw-grid-cols-3 tw-gap-5">
            <?php foreach ($themes as $slug => $theme) : 
                $is_available = !$theme['premium'] || $is_premium;
                $is_selected = ($slug === $selected);
                $preview_image = isset($theme_previews[$slug]) ? PSFA_PLUGIN_URL . 'assets/img/' . $theme_previews[$slug] : '';
                
                $card_classes = 'tw-bg-white tw-rounded-xl tw-border tw-overflow-hidden tw-transition-all';
                $card_classes .= $is_selected && $is_available 
                    ? ' tw-border-brand-primary tw-ring-1 tw-ring-brand-primary' 
                    : ' tw-border-gray-200 tw-shadow-sm hover:tw-border-gray-300';
            ?>
            <div class="<?php echo esc_attr($card_classes); ?> <?php echo $is_available ? 'tw-cursor-pointer psfa-theme-card' : 'tw-cursor-default'; ?>" <?php if ($is_available) : ?>data-theme="<?php echo esc_attr($slug); ?>"<?php endif; ?>>
                <!-- Preview Image -->
                <?php if ($preview_image) : ?>
                <div class="tw-aspect-video tw-bg-gray-100 tw-border-b tw-border-gray-200 tw-overflow-hidden psfa-theme-preview-wrapper">
                    <img src="<?php echo esc_url($preview_image); ?>" 
                         alt="<?php echo esc_attr($theme['name']); ?> Preview" 
                         class="tw-w-full tw-h-full tw-object-cover tw-object-top psfa-theme-preview-img"
                         data-full-image="<?php echo esc_url($preview_image); ?>" />
                    <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-rounded tw-absolute tw-top-3 tw-right-3 tw-bg-gray-100 tw-border tw-border-solid tw-border-gray-300 tw-text-gray-600">
                        <?php echo $theme['premium'] ? 'Premium' : 'Free'; ?>
                    </span>
                </div>
                <?php endif; ?>
                
                <!-- Card Content -->
                <div class="tw-p-4">
                    <div class="tw-flex tw-items-center tw-justify-between tw-mb-2">
                        <div class="tw-flex tw-items-center tw-gap-2">
                            <?php if ($is_available) : ?>
                            <input type="radio" name="psfa_selected_theme" value="<?php echo esc_attr($slug); ?>" 
                                   <?php checked($is_selected); ?>
                                   class="tw-hidden psfa-theme-radio" />
                            <?php endif; ?>
                            <span class="tw-text-sm tw-font-semibold tw-text-gray-900"><?php echo esc_html($theme['name']); ?></span>
                        </div>
                        <?php if ($preview_image) : ?>
                        <button type="button" 
                                class="tw-inline-flex tw-items-center tw-gap-1 tw-px-2.5 tw-py-1 tw-text-xs tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-rounded-md hover:tw-bg-blue-100 tw-transition-colors tw-border-0 tw-cursor-pointer psfa-theme-preview-button"
                                data-full-image="<?php echo esc_url($preview_image); ?>">
                            <svg class="tw-w-3.5 tw-h-3.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                            Preview
                        </button>
                        <?php endif; ?>
                    </div>
                    
                    <p class="tw-text-sm tw-text-gray-600 tw-m-0">
                        <?php echo esc_html($theme['description']); ?>
                    </p>
                    
                    <?php if (!$is_available) : ?>
                    <div class="tw-mt-3 tw-flex tw-justify-end">
                        <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" 
                           class="tw-inline-flex tw-items-center tw-px-3 tw-py-1.5 tw-text-xs tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-rounded-lg hover:tw-bg-blue-100 tw-transition-colors tw-no-underline focus:tw-outline-none">
                            Upgrade
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Save Buttons -->
        <div id="psfa-demo-themes-save-buttons" class="tw-mt-6 tw-pt-6 tw-border-t tw-border-gray-200 tw-flex tw-gap-3">
            <button type="submit" class="tw-px-5 tw-py-2.5 tw-bg-brand-primary tw-text-white tw-text-sm tw-font-medium tw-rounded-lg hover:tw-bg-brand-hover tw-transition-colors tw-cursor-pointer tw-border-0">
                Save Theme
            </button>
            <a href="<?php echo esc_url(wp_nonce_url(add_query_arg(array('page' => 'paapi-product-search-for-amazon', 'section' => 'themes', 'psfa_reset_customization' => '1'), admin_url('admin.php')), 'psfa_reset_customization')); ?>" 
               class="tw-px-5 tw-py-2.5 tw-bg-white tw-text-gray-700 tw-text-sm tw-font-medium tw-rounded-lg tw-border tw-border-gray-300 hover:tw-bg-gray-50 tw-transition-colors"
               onclick="return confirm('Reset theme settings to defaults?');">
                Reset to Defaults
            </a>
        </div>
    </form>
    <?php
}

