<?php
if (!defined('ABSPATH')) exit;

/**
 * Render shortcode builder section with Tailwind styling
 */
function psfa_render_shortcode() {
    $is_premium = false;
    $upgrade_url = 'https://paapiplugin.com/pricing/#plans';
    
    
    // Define categories
    $free_categories = array(
        'Electronics' => 'Electronics',
        'Books' => 'Books',
        'Fashion' => 'Fashion',
        'ToysAndGames' => 'Toys & Games',
        'HomeAndGarden' => 'Home & Garden',
    );
    
    $premium_categories = array(
        'OfficeProducts' => 'Office Products',
        'VideoGames' => 'Video Games',
        'MusicalInstruments' => 'Musical Instruments',
        'Automotive' => 'Automotive',
        'Baby' => 'Baby',
        'Beauty' => 'Beauty',
        'Computers' => 'Computers',
        'HealthPersonalCare' => 'Health & Personal Care',
        'KindleStore' => 'Kindle Store',
        'MoviesAndTV' => 'Movies & TV',
        'Music' => 'Music',
        'PetSupplies' => 'Pet Supplies',
        'Software' => 'Software',
        'SportsAndOutdoors' => 'Sports & Outdoors',
        'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
    );
    
    $categories = $is_premium ? array_merge($free_categories, $premium_categories) : $free_categories;
    ?>
    
    <!-- Shortcode Builder Grid -->
    <div class="tw-grid tw-grid-cols-1 lg:tw-grid-cols-2 tw-gap-4 tw-mb-6">
        
        <!-- Search & Content Card -->
        <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
            <div class="tw-flex tw-items-center tw-gap-2 tw-mb-4">
                <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Search & Content</h3>
                <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Free</span>
            </div>
            <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Configure default search query and category.</p>
            
            <div class="tw-space-y-4">
                <div>
                    <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Default Query</label>
                    <input type="text" id="psfa-sc-query" 
                           class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                           placeholder="e.g., laptop, headphones" />
                </div>
                <div>
                    <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Category</label>
                    <select id="psfa-sc-category" class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none tw-bg-white">
                        <option value="">-- Default (All) --</option>
                        <?php foreach ($categories as $value => $label) : ?>
                        <option value="<?php echo esc_attr($value); ?>"><?php echo esc_html($label); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <?php if (!$is_premium) : ?>
                    <p class="tw-text-xs tw-text-gray-500 tw-m-0 tw-mt-2">
                        <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" class="tw-text-brand-primary tw-no-underline hover:tw-opacity-80">Upgrade to Premium</a> to access all 26 categories.
                    </p>
                    <?php endif; ?>
                </div>
                <div>
                    <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Brand</label>
                    <input type="text" id="psfa-sc-brand" 
                           class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                           placeholder="e.g., Apple, Samsung" />
                </div>
                <div>
                    <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Sort By</label>
                    <select id="psfa-sc-sort" class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none tw-bg-white">
                        <option value="">-- Default --</option>
                        <option value="Relevance">Relevance</option>
                        <option value="Price:LowToHigh">Price: Low to High</option>
                        <option value="Price:HighToLow">Price: High to Low</option>
                        <option value="NewestArrivals">Newest Arrivals</option>
                        <option value="AvgCustomerReviews">Customer Reviews</option>
                        <option value="Featured">Featured</option>
                    </select>
                </div>
            </div>
        </div>
        
        <!-- Display Options Card -->
        <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
            <div class="tw-flex tw-items-center tw-gap-2 tw-mb-4">
                <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Display Options</h3>
                <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Free</span>
            </div>
            <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Control visibility and pagination behavior.</p>
            
            <div class="tw-space-y-4">
                <div>
                    <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Pagination</label>
                    <select id="psfa-sc-pagination" class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none tw-bg-white">
                        <option value="">-- Default (infinite) --</option>
                        <option value="infinite">Infinite Scroll</option>
                        <option value="button">Load More Button</option>
                        <option value="none">No Pagination</option>
                    </select>
                </div>
                <div>
                    <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-3">Visibility</label>
                    <div class="tw-space-y-3">
                        <label class="tw-flex tw-items-center tw-justify-between tw-cursor-pointer">
                            <span class="tw-text-sm tw-text-gray-700">Hide Search Box</span>
                            <span class="psfa-toggle">
                                <input type="checkbox" id="psfa-sc-hide-search" />
                                <span class="psfa-toggle-slider"></span>
                            </span>
                        </label>
                        <label class="tw-flex tw-items-center tw-justify-between tw-cursor-pointer">
                            <span class="tw-text-sm tw-text-gray-700">Hide Filters</span>
                            <span class="psfa-toggle">
                                <input type="checkbox" id="psfa-sc-hide-filters" />
                                <span class="psfa-toggle-slider"></span>
                            </span>
                        </label>
                        <label class="tw-flex tw-items-center tw-justify-between tw-cursor-pointer">
                            <span class="tw-text-sm tw-text-gray-700">Hide Category Banner</span>
                            <span class="psfa-toggle">
                                <input type="checkbox" id="psfa-sc-hide-category-banner" />
                                <span class="psfa-toggle-slider"></span>
                            </span>
                        </label>
                        <label class="tw-flex tw-items-center tw-justify-between tw-cursor-pointer">
                            <span class="tw-text-sm tw-text-gray-700">Auto-detect Category</span>
                            <span class="psfa-toggle">
                                <input type="checkbox" id="psfa-sc-auto-detect" checked />
                                <span class="psfa-toggle-slider"></span>
                            </span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Generated Shortcode Card -->
    <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5 tw-mb-6">
        <div class="tw-flex tw-items-center tw-gap-2 tw-mb-4">
            <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Generated Shortcode</h3>
        </div>
        <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Copy this shortcode and paste it into any page or post.</p>
        
        <div class="tw-flex tw-gap-3 tw-items-center">
            <code id="psfa-sc-output" class="tw-flex-1 tw-px-4 tw-py-3 tw-bg-gray-50 tw-border tw-border-gray-200 tw-rounded-lg tw-text-sm tw-font-mono tw-text-gray-800" style="word-break: break-all;">[psfa_search]</code>
            <button type="button" id="psfa-sc-copy" class="tw-px-4 tw-py-2.5 tw-bg-brand-primary tw-text-white tw-text-sm tw-font-medium tw-rounded-lg hover:tw-bg-brand-hover tw-transition-colors tw-cursor-pointer tw-border-0 tw-flex tw-items-center tw-gap-2">
                <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                </svg>
                Copy
            </button>
        </div>
        <p id="psfa-sc-copy-feedback" class="tw-text-sm tw-text-green-600 tw-m-0 tw-mt-2"></p>
    </div>
    
    <!-- Usage Examples Card -->
    <div class="tw-bg-amber-50 tw-rounded-xl tw-border tw-border-amber-200 tw-p-5">
        <div class="tw-flex tw-items-center tw-gap-2 tw-mb-4">
            <svg class="tw-w-5 tw-h-5 tw-text-amber-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z" />
            </svg>
            <h3 class="tw-text-sm tw-font-semibold tw-text-amber-900 tw-m-0">Usage Examples</h3>
        </div>
        <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-2 tw-gap-4">
            <div>
                <p class="tw-text-sm tw-font-medium tw-text-amber-800 tw-m-0 tw-mb-1">Basic:</p>
                <code class="tw-text-xs tw-text-amber-700 tw-bg-amber-100 tw-px-2 tw-py-1 tw-rounded">[psfa_search]</code>
            </div>
            <div>
                <p class="tw-text-sm tw-font-medium tw-text-amber-800 tw-m-0 tw-mb-1">Pre-filled search:</p>
                <code class="tw-text-xs tw-text-amber-700 tw-bg-amber-100 tw-px-2 tw-py-1 tw-rounded">[psfa_search query="wireless headphones"]</code>
            </div>
            <div>
                <p class="tw-text-sm tw-font-medium tw-text-amber-800 tw-m-0 tw-mb-1">Category page:</p>
                <code class="tw-text-xs tw-text-amber-700 tw-bg-amber-100 tw-px-2 tw-py-1 tw-rounded">[psfa_search category="Electronics" hide_search="true"]</code>
            </div>
            <div>
                <p class="tw-text-sm tw-font-medium tw-text-amber-800 tw-m-0 tw-mb-1">Product listing:</p>
                <code class="tw-text-xs tw-text-amber-700 tw-bg-amber-100 tw-px-2 tw-py-1 tw-rounded">[psfa_search query="iphone" hide_search="true" hide_filters="true"]</code>
            </div>
        </div>
    </div>
    
    <script type="text/javascript">
    (function() {
        var scQuery = document.getElementById('psfa-sc-query');
        var scCategory = document.getElementById('psfa-sc-category');
        var scBrand = document.getElementById('psfa-sc-brand');
        var scSort = document.getElementById('psfa-sc-sort');
        var scPagination = document.getElementById('psfa-sc-pagination');
        var scHideSearch = document.getElementById('psfa-sc-hide-search');
        var scHideFilters = document.getElementById('psfa-sc-hide-filters');
        var scHideCategoryBanner = document.getElementById('psfa-sc-hide-category-banner');
        var scAutoDetect = document.getElementById('psfa-sc-auto-detect');
        var scOutput = document.getElementById('psfa-sc-output');
        var scCopyBtn = document.getElementById('psfa-sc-copy');
        var scCopyFeedback = document.getElementById('psfa-sc-copy-feedback');

        function generateShortcode() {
            if (!scOutput) return;
            var attrs = [];
            if (scQuery && scQuery.value.trim()) attrs.push('query="' + scQuery.value.trim() + '"');
            if (scCategory && scCategory.value) attrs.push('category="' + scCategory.value + '"');
            if (scBrand && scBrand.value.trim()) attrs.push('brand="' + scBrand.value.trim() + '"');
            if (scSort && scSort.value) attrs.push('sort="' + scSort.value + '"');
            if (scPagination && scPagination.value) attrs.push('pagination="' + scPagination.value + '"');
            if (scHideSearch && scHideSearch.checked) attrs.push('hide_search="true"');
            if (scHideFilters && scHideFilters.checked) attrs.push('hide_filters="true"');
            if (scHideCategoryBanner && scHideCategoryBanner.checked) attrs.push('hide_category_banner="true"');
            if (scAutoDetect && !scAutoDetect.checked) attrs.push('auto_detect="no"');
            
            var shortcode = '[psfa_search';
            if (attrs.length > 0) shortcode += ' ' + attrs.join(' ');
            shortcode += ']';
            scOutput.textContent = shortcode;
        }

        [scQuery, scCategory, scBrand, scSort, scPagination, scHideSearch, scHideFilters, scHideCategoryBanner, scAutoDetect].forEach(function(el) {
            if (el) {
                el.addEventListener('input', generateShortcode);
                el.addEventListener('change', generateShortcode);
            }
        });

        if (scCopyBtn && scOutput) {
            scCopyBtn.addEventListener('click', function() {
                var text = scOutput.textContent;
                navigator.clipboard.writeText(text).then(function() {
                    if (scCopyFeedback) {
                        scCopyFeedback.textContent = 'Copied to clipboard!';
                        setTimeout(function() { scCopyFeedback.textContent = ''; }, 2000);
                    }
                }).catch(function() {
                    var textArea = document.createElement('textarea');
                    textArea.value = text;
                    document.body.appendChild(textArea);
                    textArea.select();
                    document.execCommand('copy');
                    document.body.removeChild(textArea);
                    if (scCopyFeedback) {
                        scCopyFeedback.textContent = 'Copied to clipboard!';
                        setTimeout(function() { scCopyFeedback.textContent = ''; }, 2000);
                    }
                });
            });
        }
    })();
    </script>
    <?php
}
