<?php
/**
 * Admin Page - Main page rendering with sidebar navigation
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render the admin page with sidebar navigation
 */
function psfa_render_admin_page() {
    if (!current_user_can('manage_options')) {
        return;
    }
    
    // phpcs:disable WordPress.Security.NonceVerification.Recommended
    $current_section = isset($_GET['section']) ? sanitize_text_field(wp_unslash($_GET['section'])) : 
                      (isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'credentials');
    // phpcs:enable WordPress.Security.NonceVerification.Recommended
    
    require_once PSFA_PLUGIN_DIR . 'core/search/view-helpers.php';
    $is_premium = function_exists('psfa_is_premium') ? psfa_is_premium() : false;
    
    $nav_sections = array(
        'general' => array(
            'label' => 'GENERAL',
            'items' => array(
                'credentials' => 'API Credentials',
                'features' => 'Features',
            ),
        ),
        'appearance' => array(
            'label' => 'APPEARANCE',
            'items' => array(
                'themes' => 'Themes',
                'layout' => 'Layout',
                'customization' => 'Customization',
            ),
        ),
        'tools' => array(
            'label' => 'TOOLS',
            'items' => array_merge(
                array('shortcode' => 'Shortcode Builder'),
                (defined('PSFA_MOCK_MODE') && PSFA_MOCK_MODE) ? array(
                    'api-offers-test' => 'API: Offers V1/V2',
                    'api-oauth-test' => 'API: OAuth Test',
                ) : array()
            ),
        ),
    );
    
    // Allow add-ons to register their sections
    $nav_sections = apply_filters( 'psfa_admin_nav_sections', $nav_sections );
    ?>
    <div id="psfa-admin-root" class="tw-font-rubik tw-antialiased">
        <div class="tw-flex tw-min-h-screen tw-bg-gray-50">
            <aside class="tw-w-64 tw-bg-white tw-border-r tw-border-gray-200 tw-flex tw-flex-col tw-flex-shrink-0">
                <div class="tw-px-6 tw-py-5 tw-border-b tw-border-gray-200">
                    <a href="https://paapiplugin.com/" target="_blank"><img src="<?php echo esc_url(PSFA_PLUGIN_URL . 'assets/img/logo-dark-bold.png'); ?>" alt="PA-API Plugin" class="tw-h-7 tw-w-auto" /></a>
                </div>
                <nav class="tw-flex-1 tw-py-4 tw-overflow-y-auto">
                    <?php foreach ($nav_sections as $section_key => $section) : ?>
                        <div class="tw-mb-4">
                            <div class="tw-px-6 tw-py-2 tw-text-xs tw-font-bold tw-text-gray-500 tw-uppercase tw-tracking-wider">
                                <?php echo esc_html($section['label']); ?>
                            </div>
                            <ul class="tw-mt-1">
                                <?php foreach ($section['items'] as $item_key => $item_label) : 
                                    $is_active = ($current_section === $item_key);
                                    $item_url = add_query_arg(array('page' => 'paapi-product-search-for-amazon', 'section' => $item_key), admin_url('admin.php'));
                                    $link_classes = $is_active 
                                        ? 'tw-block tw-px-6 tw-py-2.5 tw-text-sm tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-border-r-0 tw-border-t-0 tw-border-b-0 focus:tw-outline-0 tw-border-l-4 tw-border-solid tw-border-primary tw-no-underline'
                                        : 'tw-block tw-px-6 tw-py-2.5 tw-text-sm tw-text-gray-700 hover:tw-bg-gray-50 hover:tw-text-gray-900 tw-border-r-0 tw-border-t-0 focus:tw-outline-0 tw-border-b-0 tw-border-l-4 tw-border-solid tw-border-transparent tw-no-underline';
                                ?>
                                    <li><a href="<?php echo esc_url($item_url); ?>" class="<?php echo esc_attr($link_classes); ?>"><?php echo esc_html($item_label); ?></a></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endforeach; ?>
                </nav>
                <?php if (!$is_premium) : ?>
                <div class="tw-p-4 tw-border-t tw-border-gray-200">
                    <a href="https://paapiplugin.com/pricing/#plans" target="_blank" class="tw-flex tw-items-center tw-justify-center tw-gap-2 tw-w-full tw-px-4 tw-py-2.5 tw-bg-brand-primary tw-text-white tw-text-sm tw-font-medium tw-rounded-lg hover:tw-bg-brand-hover tw-transition-colors tw-no-underline focus:tw-outline-none">
                        <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" /></svg>
                        Upgrade to Premium
                    </a>
                </div>
                <?php endif; ?>
            </aside>
            <main class="tw-flex-1 tw-p-8">
                <div class="tw-mb-8">
                    <h1 class="tw-text-2xl tw-font-semibold tw-text-gray-900 tw-m-0"><?php echo esc_html(psfa_get_section_title($current_section)); ?></h1>
                    <p class="tw-mt-1 tw-text-sm tw-text-gray-500 tw-m-0"><?php echo esc_html(psfa_get_section_desc($current_section)); ?></p>
                </div>
                <div class="tw-max-w-5xl"><?php psfa_render_section($current_section, $is_premium); ?></div>
            </main>
        </div>
    </div>
    <?php
}

function psfa_get_section_title($section) {
    $titles = array(
        'credentials' => 'API Credentials', 'features' => 'Features', 'themes' => 'Themes',
        'layout' => 'Layout', 'customization' => 'Customization', 'shortcode' => 'Shortcode Builder',
        'api-offers-test' => 'Offers V1/V2 Comparison', 'api-oauth-test' => 'OAuth Credentials Test',
    );
    // Allow add-ons to register their section titles
    $titles = apply_filters( 'psfa_admin_section_titles', $titles );
    return isset($titles[$section]) ? $titles[$section] : 'Settings';
}

function psfa_get_section_desc($section) {
    $descriptions = array(
        'credentials' => 'Configure your Amazon Product Advertising API credentials.',
        'features' => 'View available features for your product search.',
        'themes' => 'Choose a theme for your product display.',
        'layout' => 'Configure how products are displayed.',
        'customization' => 'Customize colors, fonts, and buttons.',
        'shortcode' => 'Generate shortcodes for your pages.',
        'api-offers-test' => 'Compare Offers V1 vs OffersV2 API responses.',
        'api-oauth-test' => 'Test OAuth 2.0 credentials for Creators API.',
    );
    // Allow add-ons to register their section descriptions
    $descriptions = apply_filters( 'psfa_admin_section_descriptions', $descriptions );
    return isset($descriptions[$section]) ? $descriptions[$section] : '';
}

function psfa_render_section($section, $is_premium) {
    switch ($section) {
        case 'credentials': psfa_render_credentials(); break;
        case 'features': psfa_render_features($is_premium); break;
        case 'themes': psfa_render_themes($is_premium); break;
        case 'layout': psfa_render_layout($is_premium); break;
        case 'customization': psfa_render_customization(); break;
        case 'shortcode': psfa_render_shortcode(); break;
        case 'api-offers-test':
            if (defined('PSFA_MOCK_MODE') && PSFA_MOCK_MODE && function_exists('psfa_render_offers_comparison_page')) {
                psfa_render_offers_comparison_page();
            } else { psfa_render_credentials(); }
            break;
        case 'api-oauth-test':
            if (defined('PSFA_MOCK_MODE') && PSFA_MOCK_MODE && function_exists('psfa_render_oauth_test_page')) {
                psfa_render_oauth_test_page();
            } else { psfa_render_credentials(); }
            break;
        default:
            // Allow add-ons to render their sections
            $rendered = apply_filters( 'psfa_render_admin_section', false, $section, $is_premium );
            if ( ! $rendered ) {
                psfa_render_credentials();
            }
    }
}
