<?php
if (!defined('ABSPATH'))
    exit;

/**
 * Render layout section with Tailwind styling
 */
function psfa_render_layout($is_premium)
{
    require_once PSFA_PLUGIN_DIR . 'core/shared/theme-manager.php';
    require_once PSFA_PLUGIN_DIR . 'core/shared/customization-helpers.php';

    $upgrade_url = 'https://paapiplugin.com/pricing/#plans';
    

    // Get current settings
    $current_mode = get_option('psfa_display_mode', 'grid');
    $hide_banner = get_option('psfa_hide_category_banner', false);
    $hide_search = in_array(get_option('psfa_hide_search', '0'), array('1', 1, true, 'true'), true);
    $hide_filters = in_array(get_option('psfa_hide_filters', '0'), array('1', 1, true, 'true'), true);
    $filter_visibility = get_option('psfa_filter_visibility', array(
        'brand' => true,
        'price' => true,
        'sort' => true,
        'condition' => true,
        'merchant' => true,
        'availability' => true,
        'has_deal' => true,
        'deals' => true,
    ));

    // Force grid mode for free users
    if ($current_mode === 'list' && !$is_premium) {
        $current_mode = 'grid';
    }

    // Preserve other settings - API credentials
    $auth_type = get_option('psfa_auth_type', 'awssig4');
    $access_key = get_option('psfa_access_key_id', '');
    $secret_key = get_option('psfa_secret_access_key', '');
    $associate_tag = get_option('psfa_associate_tag', '');
    $oauth_client_id = get_option('psfa_oauth_client_id', '');
    $oauth_client_secret = get_option('psfa_oauth_client_secret', '');
    $oauth_credential_version = get_option('psfa_oauth_credential_version', '');
    $oauth_auth_region = get_option('psfa_oauth_auth_region', 'us-east-1');
    $marketplace = get_option('psfa_marketplace', 'www.amazon.com');
    $selected_theme = psfa_get_selected_theme();
    $button_text = get_option('psfa_button_text', 'Buy on Amazon');
    $button_border_radius = get_option('psfa_button_border_radius', '');
    $button_font_size = get_option('psfa_button_font_size', '');
    $button_font_weight = get_option('psfa_button_font_weight', '');
    $card_layout = get_option('psfa_card_layout', 'default');
    $title_font = get_option('psfa_title_font', '');
    $description_font = get_option('psfa_description_font', '');
    $price_font = get_option('psfa_price_font', '');
    $theme_colors = get_option('psfa_theme_colors', array());
    ?>
    <form action="options.php" method="post">
        <?php settings_fields('psfa_settings'); ?>
        
        <!-- Hidden fields to preserve settings -->
        <input type="hidden" name="psfa_auth_type" value="<?php echo esc_attr($auth_type); ?>">
        <input type="hidden" name="psfa_access_key_id" value="<?php echo esc_attr($access_key); ?>">
        <input type="hidden" name="psfa_secret_access_key" value="<?php echo esc_attr($secret_key); ?>">
        <input type="hidden" name="psfa_associate_tag" value="<?php echo esc_attr($associate_tag); ?>">
        <input type="hidden" name="psfa_oauth_client_id" value="<?php echo esc_attr($oauth_client_id); ?>">
        <input type="hidden" name="psfa_oauth_client_secret" value="<?php echo esc_attr($oauth_client_secret); ?>">
        <input type="hidden" name="psfa_oauth_credential_version" value="<?php echo esc_attr($oauth_credential_version); ?>">
        <input type="hidden" name="psfa_oauth_auth_region" value="<?php echo esc_attr($oauth_auth_region); ?>">
        <input type="hidden" name="psfa_marketplace" value="<?php echo esc_attr($marketplace); ?>">
        <input type="hidden" name="psfa_selected_theme" value="<?php echo esc_attr($selected_theme); ?>">
        <input type="hidden" name="psfa_button_text" value="<?php echo esc_attr($button_text); ?>">
        <input type="hidden" name="psfa_button_border_radius" value="<?php echo esc_attr($button_border_radius); ?>">
        <input type="hidden" name="psfa_button_font_size" value="<?php echo esc_attr($button_font_size); ?>">
        <input type="hidden" name="psfa_button_font_weight" value="<?php echo esc_attr($button_font_weight); ?>">
        <input type="hidden" name="psfa_card_layout" value="<?php echo esc_attr($card_layout); ?>">
        <input type="hidden" name="psfa_title_font" value="<?php echo esc_attr($title_font); ?>">
        <input type="hidden" name="psfa_description_font" value="<?php echo esc_attr($description_font); ?>">
        <input type="hidden" name="psfa_price_font" value="<?php echo esc_attr($price_font); ?>">
        <?php if (!empty($theme_colors)): ?>
            <?php foreach ($theme_colors as $theme_slug => $colors): ?>
                <?php foreach ($colors as $color_key => $color_value): ?>
                    <input type="hidden" name="psfa_theme_colors[<?php echo esc_attr($theme_slug); ?>][<?php echo esc_attr($color_key); ?>]" value="<?php echo esc_attr($color_value); ?>">
                <?php endforeach; ?>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <!-- Display Layout Cards -->
        <div class="tw-mb-6">
            <h2 class="tw-text-base tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-3">Display Layout</h2>
            <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Choose how products are displayed on your site.</p>
            
            <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-2 tw-gap-4">
                <!-- Grid Layout Card -->
                <?php $grid_selected = ($current_mode === 'grid'); ?>
                <div class="tw-bg-white tw-rounded-xl tw-border tw-overflow-hidden tw-transition-all tw-cursor-pointer psfa-layout-card tw-p-5 <?php echo $grid_selected ? 'tw-border-brand-primary tw-ring-1 tw-ring-brand-primary' : 'tw-border-gray-200 tw-shadow-sm hover:tw-border-gray-300'; ?>" data-mode="grid">
                    <div class="tw-flex tw-items-center tw-justify-between tw-mb-3">
                        <div class="tw-flex tw-items-center tw-gap-3">
                            <div class="tw-w-10 tw-h-10 tw-bg-gray-100 tw-rounded-lg tw-flex tw-items-center tw-justify-center">
                                <svg class="tw-w-5 tw-h-5 tw-text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Grid Layout</h3>
                            </div>
                        </div>
                        <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Free</span>
                    </div>
                    <p class="tw-text-sm tw-text-gray-600 tw-m-0">Products displayed in a responsive grid format, perfect for browsing multiple items at once.</p>
                    <input type="radio" name="psfa_display_mode" value="grid" <?php checked($grid_selected); ?> class="tw-hidden psfa-layout-radio" />
                </div>
                
                <!-- List Layout Card -->
                <?php $list_selected = ($current_mode === 'list' && $is_premium); ?>
                <div class="tw-bg-white tw-rounded-xl tw-border tw-overflow-hidden tw-transition-all psfa-layout-card tw-p-5 <?php echo $is_premium ? 'tw-cursor-pointer' : ''; ?> <?php echo $list_selected ? 'tw-border-brand-primary tw-ring-1 tw-ring-brand-primary' : 'tw-border-gray-200 tw-shadow-sm hover:tw-border-gray-300'; ?>" <?php if ($is_premium): ?>data-mode="list"<?php endif; ?>>
                    <div class="tw-flex tw-items-center tw-justify-between tw-mb-3">
                        <div class="tw-flex tw-items-center tw-gap-3">
                            <div class="tw-w-10 tw-h-10 tw-bg-gray-100 tw-rounded-lg tw-flex tw-items-center tw-justify-center">
                                <svg class="tw-w-5 tw-h-5 tw-text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 10h16M4 14h16M4 18h16" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">List Layout</h3>
                            </div>
                        </div>
                        <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Premium</span>
                    </div>
                    <p class="tw-text-sm tw-text-gray-600 tw-m-0">Products displayed in a vertical list format, ideal for detailed product information and comparisons.</p>
                    <?php if ($is_premium): ?>
                    <input type="radio" name="psfa_display_mode" value="list" <?php checked($list_selected); ?> class="tw-hidden psfa-layout-radio" />
                    <?php else: ?>
                    <div class="tw-mt-3 tw-flex tw-justify-end">
                        <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" 
                            class="tw-inline-flex tw-items-center tw-px-3 tw-py-1.5 tw-text-xs tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-rounded-lg hover:tw-bg-blue-100 tw-transition-colors tw-no-underline focus:tw-outline-none">
                            Upgrade
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Display Options & Filter Visibility Grid -->
        <div class="tw-grid tw-grid-cols-1 lg:tw-grid-cols-2 tw-gap-4 tw-mb-6">
            <!-- Display Options Card -->
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2 tw-mb-4">
                    <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Display Options</h3>
                    <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Free</span>
                </div>
                <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Control visibility of UI elements. These can be overridden per-page using shortcode attributes.</p>
       
                <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-2 tw-gap-3">
                    <label class="tw-flex tw-items-center tw-justify-between tw-p-3 tw-bg-gray-50 tw-rounded-lg tw-cursor-pointer hover:tw-bg-gray-100 tw-transition-colors">
                        <span class="tw-text-sm tw-text-gray-700">Hide Search Bar <?php echo wp_kses_post(psfa_info_tip('Hide the search input field. Useful for category-only or curated product pages.')); ?></span>
                        <span class="psfa-toggle">
                            <input type="checkbox" name="psfa_hide_search" value="1" <?php checked($hide_search); ?> />
                            <span class="psfa-toggle-slider"></span>
                        </span>
                    </label>
                    
                    <label class="tw-flex tw-items-center tw-justify-between tw-p-3 tw-bg-gray-50 tw-rounded-lg tw-cursor-pointer hover:tw-bg-gray-100 tw-transition-colors">
                        <span class="tw-text-sm tw-text-gray-700">Hide Filters <?php echo wp_kses_post(psfa_info_tip('Hide the filter bar entirely. Useful for simple product listings.')); ?></span>
                        <span class="psfa-toggle">
                            <input type="checkbox" name="psfa_hide_filters" value="1" <?php checked($hide_filters); ?> />
                            <span class="psfa-toggle-slider"></span>
                        </span>
                    </label>
                    
                    <label class="tw-flex tw-items-center tw-justify-between tw-p-3 tw-bg-gray-50 tw-rounded-lg tw-cursor-pointer hover:tw-bg-gray-100 tw-transition-colors">
                        <span class="tw-text-sm tw-text-gray-700">Hide Category Banner <?php echo wp_kses_post(psfa_info_tip('Hide the "Top Products in [Category]" banner header on category pages.')); ?></span>
                        <span class="psfa-toggle">
                            <input type="checkbox" name="psfa_hide_category_banner" value="1" <?php checked($hide_banner); ?> />
                            <span class="psfa-toggle-slider"></span>
                        </span>
                    </label>
                    
                    <?php  ?>
                </div>
                
                <?php if (!$is_premium): ?>
                <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mt-4">
                    <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" class="tw-text-brand-primary tw-no-underline hover:tw-opacity-80">Upgrade to Premium</a> for white-label mode (remove "Powered by" branding).
                </p>
                <?php endif; ?>
            </div>
            
            <!-- Filter Visibility Card -->
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
            <div class="tw-flex tw-items-center tw-gap-2 tw-mb-2">
                <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Filter Visibility</h3>
                <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Free</span>
            </div>
            <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Choose which filters to display in the search interface.</p>
            
            <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-2 tw-gap-3">
                <?php
                $free_filters = array(
                    'brand' => 'Brand',
                    'price' => 'Price Range',
                    'sort' => 'Sort By',
                    'condition' => 'Condition',
                    'merchant' => 'Merchant',
                    'availability' => 'Availability',
                );
                $premium_filters = array(
                    'has_deal' => 'Has Deal',
                    'deals' => 'Discounts',
                );

                foreach ($free_filters as $key => $label):
                    ?>
                <label class="tw-flex tw-items-center tw-justify-between tw-p-3 tw-bg-gray-50 tw-rounded-lg tw-cursor-pointer hover:tw-bg-gray-100 tw-transition-colors">
                    <span class="tw-text-sm tw-text-gray-700"><?php echo esc_html($label); ?></span>
                    <span class="psfa-toggle">
                        <input type="checkbox" name="psfa_filter_visibility[<?php echo esc_attr($key); ?>]" value="1" <?php checked(!empty($filter_visibility[$key])); ?> />
                        <span class="psfa-toggle-slider"></span>
                    </span>
                </label>
                <?php endforeach; ?>
                
                <?php  ?>
            </div>
            
            <?php if (!$is_premium): ?>
            <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mt-4">
                <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" class="tw-text-brand-primary tw-no-underline hover:tw-opacity-80">Upgrade to Premium</a> for additional filters: Has Deal and Discounts.
            </p>
            <?php endif; ?>
            </div>
        </div>
        
        <!-- Badge & Deal Settings -->
        <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5 tw-mb-6">
            <div class="tw-flex tw-items-center tw-gap-2 tw-mb-2">
                <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Badge & Deal Settings</h3>
                <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Premium</span>
            </div>
            <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Configure which product badges and deal indicators to display.</p>
            
            <?php  ?>
            <ul class="tw-text-sm tw-text-gray-600 tw-m-0 tw-mb-4 tw-pl-5 tw-space-y-1" style="list-style: disc;">
                <li>Deal Badges - Lightning Deal, Best Deal badges</li>
                <li>Prime Exclusive Deals indicator</li>
                <li>Low Stock warning animation</li>
                <li>Deal Countdown timer</li>
            </ul>
            <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" 
               class="tw-inline-flex tw-items-center tw-px-3 tw-py-1.5 tw-text-xs tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-rounded-lg hover:tw-bg-blue-100 tw-transition-colors tw-no-underline focus:tw-outline-none">
                Upgrade
            </a>
            <?php  ?>
        </div>
        
        <!-- Save Buttons -->
        <div class="tw-flex tw-gap-3">
            <button type="submit" class="tw-px-5 tw-py-2.5 tw-bg-brand-primary tw-text-white tw-text-sm tw-font-medium tw-rounded-lg hover:tw-bg-brand-hover tw-transition-colors tw-cursor-pointer tw-border-0">
                Save Layout
            </button>
            <a href="<?php echo esc_url(wp_nonce_url(add_query_arg(array('page' => 'paapi-product-search-for-amazon', 'section' => 'layout', 'psfa_reset_customization' => '1'), admin_url('admin.php')), 'psfa_reset_customization')); ?>" 
               class="tw-px-5 tw-py-2.5 tw-bg-white tw-text-gray-700 tw-text-sm tw-font-medium tw-rounded-lg tw-border tw-border-gray-300 hover:tw-bg-gray-50 tw-transition-colors tw-no-underline focus:tw-outline-none"
               onclick="return confirm('Reset layout settings to defaults?');">
                Reset to Defaults
            </a>
        </div>
    </form>
    <?php
}
