<?php
/**
 * Admin Features Section
 * 
 * Renders the features overview and badge settings.
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render features section with all features
 */
function psfa_render_features($is_premium) {
    require_once PSFA_PLUGIN_DIR . 'core/admin/premium-features.php';
    
    // Get all premium features from the registry
    $premium_features = psfa_get_all_premium_features();
    
    // Free features (always enabled)
    $free_features = array(
        array('name' => 'Shortcode Builder', 'description' => 'Visual shortcode builder to easily create and customize your product search shortcodes.', 'icon' => 'code'),
        array('name' => 'Search Autocomplete', 'description' => 'Real-time search suggestions as users type, powered by Amazon\'s search data.', 'icon' => 'search'),
        array('name' => 'Product Filters', 'description' => 'Filter products by brand, price range, condition, and merchant.', 'icon' => 'filter'),
        array('name' => 'Grid Display Mode', 'description' => 'Display products in a responsive grid layout that works on all devices.', 'icon' => 'grid'),
        array('name' => 'Infinite Scroll', 'description' => 'Automatically load more products as users scroll (up to 5 pages in free version).', 'icon' => 'arrow-down'),
        array('name' => 'Filter Visibility Control', 'description' => 'Choose which filters to show or hide in the search interface.', 'icon' => 'eye'),
        array('name' => 'Category Selection', 'description' => 'Search within specific Amazon categories (5 categories in free version).', 'icon' => 'folder'),
    );
    ?>
    
    <!-- Free Features -->
    <div class="tw-mb-8">
        <h2 class="tw-text-lg tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-4">Free Features</h2>
        <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-2 tw-gap-4">
            <?php foreach ($free_features as $feature) : ?>
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-start tw-justify-between tw-gap-4">
                    <div class="tw-flex-1">
                        <div class="tw-flex tw-items-center tw-gap-2 tw-mb-2">
                            <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php echo esc_html($feature['name']); ?></h3>
                            <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-700 tw-rounded">Free</span>
                        </div>
                        <p class="tw-text-sm tw-text-gray-600 tw-m-0"><?php echo esc_html($feature['description']); ?></p>
                    </div>
                    <div class="tw-flex-shrink-0">
                        <span class="tw-flex tw-items-center tw-justify-center tw-w-5 tw-h-5 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                            <svg class="tw-w-3 tw-h-3" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                        </span>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    
    <!-- Premium Features -->
    <div>
        <h2 class="tw-text-lg tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-4">Premium Features</h2>
        <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-2 tw-gap-4">
            <?php foreach ($premium_features as $feature) : ?>
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5 <?php echo !$is_premium ? 'tw-opacity-75' : ''; ?>">
                <div class="tw-flex tw-items-start tw-justify-between tw-gap-4">
                    <div class="tw-flex-1">
                        <div class="tw-flex tw-items-center tw-gap-2 tw-mb-2">
                            <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php echo esc_html($feature['name']); ?></h3>
                            <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-700 tw-rounded">Premium</span>
                        </div>
                        <?php 
                            $display_desc = isset($feature['short_description']) ? $feature['short_description'] : wp_strip_all_tags($feature['description']);
                        ?>
                        <p class="tw-text-sm tw-text-gray-600 tw-m-0"><?php echo esc_html(wp_trim_words($display_desc, 25)); ?></p>
                    </div>
                    <div class="tw-flex-shrink-0">
                        <?php if ($is_premium) : ?>
                        <span class="tw-flex tw-items-center tw-justify-center tw-w-5 tw-h-5 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                            <svg class="tw-w-3 tw-h-3" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                        </span>
                        <?php else : ?>
                        <a href="<?php echo esc_url($feature['upgrade_url']); ?>" target="_blank" 
                           class="tw-inline-flex tw-items-center tw-px-3 tw-py-1.5 tw-text-xs tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-rounded-lg hover:tw-bg-blue-100 tw-transition-colors tw-no-underline focus:tw-outline-none">
                            Upgrade
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php
}
